/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import datadog.opentracing.DDSpan;
import datadog.trace.common.writer.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(LoggingWriter.class);
    private final ObjectMapper serializer = new ObjectMapper();

    @Override
    public void write(List<DDSpan> trace) {
        try {
            log.info("write(trace): {}", (Object)this.serializer.writeValueAsString(trace));
        }
        catch (Exception e) {
            log.error("error writing(trace): {}", trace);
        }
    }

    @Override
    public void close() {
        log.info("close()");
    }

    @Override
    public void start() {
        log.info("start()");
    }

    public String toString() {
        return "LoggingWriter { }";
    }
}

