/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;

class BuildkiteInfo
extends CIProviderInfo {
    public static final String BUILDKITE = "BUILDKITE";
    public static final String BUILDKITE_PROVIDER_NAME = "buildkite";
    public static final String BUILDKITE_PIPELINE_ID = "BUILDKITE_BUILD_ID";
    public static final String BUILDKITE_PIPELINE_NAME = "BUILDKITE_PIPELINE_SLUG";
    public static final String BUILDKITE_PIPELINE_NUMBER = "BUILDKITE_BUILD_NUMBER";
    public static final String BUILDKITE_BUILD_URL = "BUILDKITE_BUILD_URL";
    public static final String BUILDKITE_JOB_ID = "BUILDKITE_JOB_ID";
    public static final String BUILDKITE_WORKSPACE_PATH = "BUILDKITE_BUILD_CHECKOUT_PATH";
    public static final String BUILDKITE_GIT_REPOSITORY_URL = "BUILDKITE_REPO";
    public static final String BUILDKITE_GIT_COMMIT = "BUILDKITE_COMMIT";
    public static final String BUILDKITE_GIT_BRANCH = "BUILDKITE_BRANCH";
    public static final String BUILDKITE_GIT_TAG = "BUILDKITE_TAG";
    private final String ciProviderName;
    private final String ciPipelineId = System.getenv("BUILDKITE_BUILD_ID");
    private final String ciPipelineName = System.getenv("BUILDKITE_PIPELINE_SLUG");
    private final String ciPipelineNumber = System.getenv("BUILDKITE_BUILD_NUMBER");
    private final String ciPipelineUrl = System.getenv("BUILDKITE_BUILD_URL");
    private final String ciJobUrl = String.format("%s#%s", this.ciPipelineUrl, System.getenv("BUILDKITE_JOB_ID"));
    private final String ciWorkspacePath = this.expandTilde(System.getenv("BUILDKITE_BUILD_CHECKOUT_PATH"));
    private final String gitRepositoryUrl = this.filterSensitiveInfo(System.getenv("BUILDKITE_REPO"));
    private final String gitCommit = System.getenv("BUILDKITE_COMMIT");
    private final String gitBranch = this.normalizeRef(System.getenv("BUILDKITE_BRANCH"));
    private final String gitTag = this.normalizeRef(System.getenv("BUILDKITE_TAG"));

    BuildkiteInfo() {
        this.ciProviderName = BUILDKITE_PROVIDER_NAME;
    }

    @Override
    public String getCiProviderName() {
        return this.ciProviderName;
    }

    @Override
    public String getCiPipelineId() {
        return this.ciPipelineId;
    }

    @Override
    public String getCiPipelineName() {
        return this.ciPipelineName;
    }

    @Override
    public String getCiPipelineNumber() {
        return this.ciPipelineNumber;
    }

    @Override
    public String getCiPipelineUrl() {
        return this.ciPipelineUrl;
    }

    @Override
    public String getCiJobUrl() {
        return this.ciJobUrl;
    }

    @Override
    public String getCiWorkspacePath() {
        return this.ciWorkspacePath;
    }

    @Override
    public String getGitRepositoryUrl() {
        return this.gitRepositoryUrl;
    }

    @Override
    public String getGitCommit() {
        return this.gitCommit;
    }

    @Override
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Override
    public String getGitTag() {
        return this.gitTag;
    }
}

