/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;

class GithubActionsInfo
extends CIProviderInfo {
    public static final String GHACTIONS = "GITHUB_ACTION";
    public static final String GHACTIONS_PROVIDER_NAME = "github";
    public static final String GHACTIONS_PIPELINE_ID = "GITHUB_RUN_ID";
    public static final String GHACTIONS_PIPELINE_NAME = "GITHUB_WORKFLOW";
    public static final String GHACTIONS_PIPELINE_NUMBER = "GITHUB_RUN_NUMBER";
    public static final String GHACTIONS_WORKSPACE_PATH = "GITHUB_WORKSPACE";
    public static final String GHACTIONS_REPOSITORY = "GITHUB_REPOSITORY";
    public static final String GHACTIONS_SHA = "GITHUB_SHA";
    public static final String GHACTIONS_HEAD_REF = "GITHUB_HEAD_REF";
    public static final String GHACTIONS_REF = "GITHUB_REF";
    private final String ciProviderName;
    private final String ciPipelineId;
    private final String ciPipelineName;
    private final String ciPipelineNumber;
    private final String ciPipelineUrl;
    private final String ciJobUrl;
    private final String ciWorkspacePath;
    private final String gitRepositoryUrl;
    private final String gitCommit;
    private final String gitBranch;
    private final String gitTag;

    GithubActionsInfo() {
        String repo = System.getenv(GHACTIONS_REPOSITORY);
        String commit = System.getenv(GHACTIONS_SHA);
        String url = this.buildPipelineUrl(repo, commit);
        this.ciProviderName = GHACTIONS_PROVIDER_NAME;
        this.ciPipelineId = System.getenv(GHACTIONS_PIPELINE_ID);
        this.ciPipelineName = System.getenv(GHACTIONS_PIPELINE_NAME);
        this.ciPipelineNumber = System.getenv(GHACTIONS_PIPELINE_NUMBER);
        this.ciPipelineUrl = url;
        this.ciJobUrl = url;
        this.ciWorkspacePath = this.expandTilde(System.getenv(GHACTIONS_WORKSPACE_PATH));
        this.gitRepositoryUrl = this.buildGitRepositoryUrl(repo);
        this.gitCommit = commit;
        this.gitBranch = this.buildGitBranch();
        this.gitTag = this.buildGitTag();
    }

    private String buildGitTag() {
        String gitBranchOrTag = System.getenv(GHACTIONS_HEAD_REF);
        if (gitBranchOrTag == null || gitBranchOrTag.isEmpty()) {
            gitBranchOrTag = System.getenv(GHACTIONS_REF);
        }
        if (gitBranchOrTag != null && gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildGitBranch() {
        String gitBranchOrTag = System.getenv(GHACTIONS_HEAD_REF);
        if (gitBranchOrTag == null || gitBranchOrTag.isEmpty()) {
            gitBranchOrTag = System.getenv(GHACTIONS_REF);
        }
        if (gitBranchOrTag != null && !gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildGitRepositoryUrl(String repo) {
        return String.format("https://github.com/%s.git", repo);
    }

    private String buildPipelineUrl(String repo, String commit) {
        return String.format("https://github.com/%s/commit/%s/checks", repo, commit);
    }

    @Override
    public String getCiProviderName() {
        return this.ciProviderName;
    }

    @Override
    public String getCiPipelineId() {
        return this.ciPipelineId;
    }

    @Override
    public String getCiPipelineName() {
        return this.ciPipelineName;
    }

    @Override
    public String getCiPipelineNumber() {
        return this.ciPipelineNumber;
    }

    @Override
    public String getCiPipelineUrl() {
        return this.ciPipelineUrl;
    }

    @Override
    public String getCiJobUrl() {
        return this.ciJobUrl;
    }

    @Override
    public String getCiWorkspacePath() {
        return this.ciWorkspacePath;
    }

    @Override
    public String getGitRepositoryUrl() {
        return this.gitRepositoryUrl;
    }

    @Override
    public String getGitCommit() {
        return this.gitCommit;
    }

    @Override
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Override
    public String getGitTag() {
        return this.gitTag;
    }
}

