/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;

class TravisInfo
extends CIProviderInfo {
    public static final String TRAVIS = "TRAVIS";
    public static final String TRAVIS_PROVIDER_NAME = "travisci";
    public static final String TRAVIS_PIPELINE_ID = "TRAVIS_BUILD_ID";
    public static final String TRAVIS_PIPELINE_NUMBER = "TRAVIS_BUILD_NUMBER";
    public static final String TRAVIS_PIPELINE_URL = "TRAVIS_BUILD_WEB_URL";
    public static final String TRAVIS_JOB_URL = "TRAVIS_JOB_WEB_URL";
    public static final String TRAVIS_WORKSPACE_PATH = "TRAVIS_BUILD_DIR";
    public static final String TRAVIS_REPOSITORY_SLUG = "TRAVIS_REPO_SLUG";
    public static final String TRAVIS_PR_REPOSITORY_SLUG = "TRAVIS_PULL_REQUEST_SLUG";
    public static final String TRAVIS_GIT_COMMIT = "TRAVIS_COMMIT";
    public static final String TRAVIS_GIT_PR_BRANCH = "TRAVIS_PULL_REQUEST_BRANCH";
    public static final String TRAVIS_GIT_BRANCH = "TRAVIS_BRANCH";
    public static final String TRAVIS_GIT_TAG = "TRAVIS_TAG";
    private final String ciProviderName;
    private final String ciPipelineId = System.getenv("TRAVIS_BUILD_ID");
    private final String ciPipelineName;
    private final String ciPipelineNumber = System.getenv("TRAVIS_BUILD_NUMBER");
    private final String ciPipelineUrl = System.getenv("TRAVIS_BUILD_WEB_URL");
    private final String ciJobUrl = System.getenv("TRAVIS_JOB_WEB_URL");
    private final String ciWorkspacePath = this.expandTilde(System.getenv("TRAVIS_BUILD_DIR"));
    private final String gitRepositoryUrl;
    private final String gitCommit;
    private final String gitBranch;
    private final String gitTag;

    TravisInfo() {
        this.ciProviderName = TRAVIS_PROVIDER_NAME;
        this.ciPipelineName = this.buildCiPipelineName();
        this.gitRepositoryUrl = this.buildGitRepositoryUrl();
        this.gitCommit = System.getenv(TRAVIS_GIT_COMMIT);
        this.gitTag = this.normalizeRef(System.getenv(TRAVIS_GIT_TAG));
        this.gitBranch = this.buildGitBranch(this.gitTag);
    }

    private String buildGitBranch(String gitTag) {
        if (gitTag != null) {
            return null;
        }
        String fromBranch = System.getenv(TRAVIS_GIT_PR_BRANCH);
        if (fromBranch != null && !fromBranch.isEmpty()) {
            return this.normalizeRef(fromBranch);
        }
        return this.normalizeRef(System.getenv(TRAVIS_GIT_BRANCH));
    }

    private String buildGitRepositoryUrl() {
        String repoSlug = System.getenv(TRAVIS_PR_REPOSITORY_SLUG);
        if (repoSlug == null || repoSlug.isEmpty()) {
            repoSlug = System.getenv(TRAVIS_REPOSITORY_SLUG);
        }
        return String.format("https://github.com/%s.git", repoSlug);
    }

    private String buildCiPipelineName() {
        String repoSlug = System.getenv(TRAVIS_PR_REPOSITORY_SLUG);
        if (repoSlug == null || repoSlug.isEmpty()) {
            repoSlug = System.getenv(TRAVIS_REPOSITORY_SLUG);
        }
        return repoSlug;
    }

    @Override
    public String getCiProviderName() {
        return this.ciProviderName;
    }

    @Override
    public String getCiPipelineId() {
        return this.ciPipelineId;
    }

    @Override
    public String getCiPipelineName() {
        return this.ciPipelineName;
    }

    @Override
    public String getCiPipelineNumber() {
        return this.ciPipelineNumber;
    }

    @Override
    public String getCiPipelineUrl() {
        return this.ciPipelineUrl;
    }

    @Override
    public String getCiJobUrl() {
        return this.ciJobUrl;
    }

    @Override
    public String getCiWorkspacePath() {
        return this.ciWorkspacePath;
    }

    @Override
    public String getGitRepositoryUrl() {
        return this.gitRepositoryUrl;
    }

    @Override
    public String getGitCommit() {
        return this.gitCommit;
    }

    @Override
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Override
    public String getGitTag() {
        return this.gitTag;
    }
}

