/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.core.histogram.Histogram;
import datadog.trace.core.histogram.HistogramFactory;
import datadog.trace.core.histogram.Histograms;

public final class AggregateMetric {
    private static final HistogramFactory HISTOGRAM_FACTORY = Histograms.newHistogramFactory();
    private final Histogram okLatencies = HISTOGRAM_FACTORY.newHistogram();
    private final Histogram errorLatencies = HISTOGRAM_FACTORY.newHistogram();
    private int errorCount;
    private int hitCount;
    private long duration;

    public AggregateMetric recordDurations(int count, long errorMask, long ... durations) {
        this.hitCount += count;
        this.errorCount += Long.bitCount(errorMask);
        for (int i = 0; i < count && i < durations.length; ++i) {
            long duration = durations[i];
            this.duration += duration;
            if ((errorMask >>> i & 1L) == 1L) {
                this.errorLatencies.accept(duration);
                continue;
            }
            this.okLatencies.accept(duration);
        }
        return this;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public long getDuration() {
        return this.duration;
    }

    public Histogram getOkLatencies() {
        return this.okLatencies;
    }

    public Histogram getErrorLatencies() {
        return this.errorLatencies;
    }

    public void clear() {
        this.errorCount = 0;
        this.hitCount = 0;
        this.duration = 0L;
        this.okLatencies.clear();
        this.errorLatencies.clear();
    }
}

