/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import java.util.Objects;

public final class MetricKey {
    private final UTF8BytesString resource;
    private final UTF8BytesString service;
    private final UTF8BytesString operationName;
    private final UTF8BytesString type;
    private final int httpStatusCode;

    public MetricKey(CharSequence resource, CharSequence service, CharSequence operationName, CharSequence type, int httpStatusCode) {
        this.resource = UTF8BytesString.create(null == resource ? "" : resource);
        this.service = UTF8BytesString.create(null == service ? "" : service);
        this.operationName = UTF8BytesString.create(null == operationName ? "" : operationName);
        this.type = UTF8BytesString.create(null == type ? "" : type);
        this.httpStatusCode = httpStatusCode;
    }

    public UTF8BytesString getResource() {
        return this.resource;
    }

    public UTF8BytesString getService() {
        return this.service;
    }

    public UTF8BytesString getOperationName() {
        return this.operationName;
    }

    public UTF8BytesString getType() {
        return this.type;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricKey metricKey = (MetricKey)o;
        return this.httpStatusCode == metricKey.httpStatusCode && this.resource.equals(metricKey.resource) && this.service.equals(metricKey.service) && this.operationName.equals(metricKey.operationName) && this.type.equals(metricKey.type);
    }

    public int hashCode() {
        return 97 * Objects.hash(this.resource, this.service, this.operationName, this.type) + this.httpStatusCode;
    }
}

