/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.api.Function;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.common.sampling.DeterministicSampler;
import datadog.trace.common.sampling.PrioritySampler;
import datadog.trace.common.sampling.RateSampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.core.CoreSpan;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateByServiceSampler<T extends CoreSpan<T>>
implements Sampler<T>,
PrioritySampler<T>,
DDAgentResponseListener {
    private static final Logger log = LoggerFactory.getLogger(RateByServiceSampler.class);
    public static final String SAMPLING_AGENT_RATE = "_dd.agent_psr";
    private static final double DEFAULT_RATE = 1.0;
    private volatile RateSamplersByEnvAndService<T> serviceRates = new RateSamplersByEnvAndService();

    @Override
    public boolean sample(T span) {
        return true;
    }

    @Override
    public void setSamplingPriority(T span) {
        String serviceName = span.getServiceName();
        RateSamplersByEnvAndService<T> rates = this.serviceRates;
        String env = this.getSpanEnv(span);
        RateSampler<T> sampler = rates.getSampler(new EnvAndService(env, serviceName));
        if (sampler.sample(span)) {
            span.setSamplingPriority(1, SAMPLING_AGENT_RATE, sampler.getSampleRate());
        } else {
            span.setSamplingPriority(0, SAMPLING_AGENT_RATE, sampler.getSampleRate());
        }
    }

    private String getSpanEnv(T span) {
        return span.getTag("env", (String)"");
    }

    @Override
    public void onResponse(String endpoint, Map<String, Map<String, Number>> responseJson) {
        Map<String, Number> newServiceRates = responseJson.get("rate_by_service");
        if (null != newServiceRates) {
            log.debug("Update service sampler rates: {} -> {}", (Object)endpoint, responseJson);
            HashMap updatedServiceRates = new HashMap(newServiceRates.size() * 2);
            for (Map.Entry<String, Number> entry : newServiceRates.entrySet()) {
                if (entry.getValue() == null) continue;
                updatedServiceRates.put(EnvAndService.fromString(entry.getKey()), RateByServiceSampler.createRateSampler(entry.getValue().doubleValue()));
            }
            this.serviceRates = new RateSamplersByEnvAndService(updatedServiceRates);
        }
    }

    private static <T extends CoreSpan<T>> RateSampler<T> createRateSampler(double sampleRate) {
        double sanitizedRate;
        if (sampleRate < 0.0) {
            log.error("SampleRate is negative or null, disabling the sampler");
            sanitizedRate = 1.0;
        } else {
            sanitizedRate = sampleRate > 1.0 ? 1.0 : sampleRate;
        }
        return new DeterministicSampler(sanitizedRate);
    }

    static /* synthetic */ RateSampler access$100(double x0) {
        return RateByServiceSampler.createRateSampler(x0);
    }

    private static final class EnvAndService {
        private static final DDCache<String, EnvAndService> CACHE = DDCaches.newFixedSizeCache(32);
        private static final Function<String, EnvAndService> PARSE = new Function<String, EnvAndService>(){

            @Override
            public EnvAndService apply(String key) {
                int serviceStart = key.indexOf(58) + 1;
                int serviceEnd = key.indexOf(44, serviceStart);
                int envStart = key.indexOf(58, serviceEnd) + 1;
                if (serviceStart == serviceEnd && envStart == key.length() || (serviceStart | serviceEnd | envStart) < 0) {
                    return DEFAULT;
                }
                String service = key.substring(serviceStart, serviceEnd);
                String env = key.substring(envStart);
                return new EnvAndService(env, service);
            }
        };
        static final EnvAndService DEFAULT = new EnvAndService("", "");
        private final CharSequence env;
        private final CharSequence service;

        public static EnvAndService fromString(String key) {
            return CACHE.computeIfAbsent(key, PARSE);
        }

        private EnvAndService(CharSequence env, CharSequence service) {
            this.env = env;
            this.service = service;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnvAndService that = (EnvAndService)o;
            return this.env.equals(that.env) && this.service.equals(that.service);
        }

        public int hashCode() {
            return Objects.hash(this.env, this.service);
        }
    }

    private static final class RateSamplersByEnvAndService<T extends CoreSpan<T>> {
        private static final RateSampler<?> DEFAULT = RateByServiceSampler.access$100(1.0);
        private final Map<EnvAndService, RateSampler<T>> serviceRates;

        RateSamplersByEnvAndService() {
            this(new HashMap<EnvAndService, RateSampler<T>>(0));
        }

        RateSamplersByEnvAndService(Map<EnvAndService, RateSampler<T>> serviceRates) {
            this.serviceRates = serviceRates;
        }

        public RateSampler<T> getSampler(EnvAndService key) {
            RateSampler<T> sampler = this.serviceRates.get(key);
            return null == sampler ? DEFAULT : sampler;
        }
    }
}

