/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.PendingTraceBuffer;
import datadog.trace.core.monitor.Recording;
import datadog.trace.core.util.Clock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTrace
implements AgentTrace {
    private static final Logger log = LoggerFactory.getLogger(PendingTrace.class);
    private final CoreTracer tracer;
    private final DDId traceId;
    private final PendingTraceBuffer pendingTraceBuffer;
    private final long startTimeNano;
    private final long startNanoTicks;
    private final ConcurrentLinkedDeque<DDSpan> finishedSpans = new ConcurrentLinkedDeque();
    private final AtomicInteger completedSpanCount = new AtomicInteger(0);
    private final AtomicInteger pendingReferenceCount = new AtomicInteger(0);
    private volatile DDSpan rootSpan = null;
    private volatile boolean rootSpanWritten = false;
    private volatile long lastReferenced = 0L;

    private PendingTrace(@Nonnull CoreTracer tracer, @Nonnull DDId traceId, @Nonnull PendingTraceBuffer pendingTraceBuffer) {
        this.tracer = tracer;
        this.traceId = traceId;
        this.pendingTraceBuffer = pendingTraceBuffer;
        this.startTimeNano = Clock.currentNanoTime();
        this.startNanoTicks = Clock.currentNanoTicks();
    }

    CoreTracer getTracer() {
        return this.tracer;
    }

    public long getCurrentTimeNano() {
        long nanoTicks;
        this.lastReferenced = nanoTicks = Clock.currentNanoTicks();
        return this.startTimeNano + Math.max(0L, nanoTicks - this.startNanoTicks);
    }

    public void touch() {
        this.lastReferenced = Clock.currentNanoTicks();
    }

    public boolean lastReferencedNanosAgo(long nanos) {
        long currentNanoTicks = Clock.currentNanoTicks();
        long age = currentNanoTicks - this.lastReferenced;
        return nanos < age;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSpan(DDSpan span) {
        if (null == this.rootSpan) {
            PendingTrace pendingTrace = this;
            synchronized (pendingTrace) {
                if (!this.rootSpanWritten && null == this.rootSpan) {
                    this.rootSpan = span;
                }
            }
        }
        int count = this.pendingReferenceCount.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("t_id={} -> registered span {}. count = {}", new Object[]{this.traceId, span, count});
        }
    }

    void addFinishedSpan(DDSpan span) {
        this.finishedSpans.addFirst(span);
        this.completedSpanCount.incrementAndGet();
        this.decrementRefAndMaybeWrite(span == this.getRootSpan());
    }

    public DDSpan getRootSpan() {
        return this.rootSpan;
    }

    long oldestFinishedTime() {
        long oldest = Long.MAX_VALUE;
        for (DDSpan span : this.finishedSpans) {
            oldest = Math.min(oldest, span.getStartTime() + span.getDurationNano());
        }
        return oldest;
    }

    @Override
    public void registerContinuation(AgentScope.Continuation continuation) {
        int count = this.pendingReferenceCount.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("t_id={} -> registered continuation {} -- count = {}", new Object[]{this.traceId, continuation, count});
        }
    }

    @Override
    public void cancelContinuation(AgentScope.Continuation continuation) {
        this.decrementRefAndMaybeWrite(false);
    }

    private void decrementRefAndMaybeWrite(boolean isRootSpan) {
        int count = this.pendingReferenceCount.decrementAndGet();
        int partialFlushMinSpans = this.tracer.getPartialFlushMinSpans();
        if (count == 0 && !this.rootSpanWritten) {
            this.write();
        } else if (isRootSpan) {
            this.pendingTraceBuffer.enqueue(this);
        } else if (0 < partialFlushMinSpans && partialFlushMinSpans < this.size()) {
            this.partialFlush();
        } else if (this.rootSpanWritten) {
            this.pendingTraceBuffer.enqueue(this);
        }
        if (log.isDebugEnabled()) {
            log.debug("t_id={} -> expired reference. root={} pending count={}", new Object[]{this.traceId, isRootSpan, count});
        }
    }

    private void partialFlush() {
        int size = this.write(true);
        if (log.isDebugEnabled()) {
            log.debug("t_id={} -> wrote partial trace of size {}", (Object)this.traceId, (Object)size);
        }
    }

    void write() {
        int size = this.write(false);
        if (log.isDebugEnabled()) {
            log.debug("t_id={} -> wrote {} spans to {}.", new Object[]{this.traceId, size, this.tracer.writer});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(boolean isPartial) {
        if (!this.finishedSpans.isEmpty()) {
            try (Recording recording = this.tracer.writeTimer();){
                PendingTrace pendingTrace = this;
                synchronized (pendingTrace) {
                    block22: {
                        int size;
                        if (!isPartial) {
                            this.rootSpanWritten = true;
                        }
                        if ((size = this.size()) <= 0 || isPartial && size <= this.tracer.getPartialFlushMinSpans()) break block22;
                        ArrayList<DDSpan> trace = new ArrayList<DDSpan>(size);
                        Iterator<DDSpan> it = this.finishedSpans.iterator();
                        int i = 0;
                        while (it.hasNext()) {
                            DDSpan span = it.next();
                            trace.add(span);
                            this.completedSpanCount.decrementAndGet();
                            it.remove();
                            ++i;
                        }
                        this.tracer.write(trace);
                        int n = i;
                        return n;
                    }
                }
            }
        }
        return 0;
    }

    public int size() {
        return this.completedSpanCount.get();
    }

    static class Factory {
        private final CoreTracer tracer;
        private final PendingTraceBuffer pendingTraceBuffer;

        Factory(CoreTracer tracer, PendingTraceBuffer pendingTraceBuffer) {
            this.tracer = tracer;
            this.pendingTraceBuffer = pendingTraceBuffer;
        }

        PendingTrace create(@Nonnull DDId traceId) {
            return new PendingTrace(this.tracer, traceId, this.pendingTraceBuffer);
        }
    }
}

