/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.processor.rule;

import datadog.trace.core.DDSpanContext;
import datadog.trace.core.processor.TraceProcessor;

public class URLAsResourceNameRule
implements TraceProcessor.Rule {
    private static final Integer NOT_FOUND = 404;
    private static final BitSlicedBitapSearch PROTOCOL_SEARCH = new BitSlicedBitapSearch("://");

    @Override
    public String[] aliases() {
        return new String[]{"URLAsResourceName", "Status404Rule", "Status404Decorator"};
    }

    @Override
    public void processSpan(DDSpanContext span) {
        if (span.isResourceNameSet()) {
            return;
        }
        Object httpStatus = span.unsafeGetTag("http.status_code");
        if (NOT_FOUND.equals(httpStatus) || "404".equals(httpStatus)) {
            span.setResourceName("404");
            return;
        }
        Object url = span.unsafeGetTag("http.url");
        if (null == url) {
            return;
        }
        span.setResourceName(this.extractResourceNameFromURL(span.unsafeGetTag("http.method"), url.toString()));
    }

    private String extractResourceNameFromURL(Object method, String url) {
        int start;
        if (url.isEmpty()) {
            return null == method ? "/" : method.toString().toUpperCase().trim() + " /";
        }
        StringBuilder resourceName = new StringBuilder(16);
        if (method != null) {
            String verb = method.toString().toUpperCase().trim();
            resourceName.append(verb).append(' ');
        }
        boolean hasProtocol = (start = URLAsResourceNameRule.protocolPosition(url)) >= 0;
        start += hasProtocol ? 3 : 1;
        if (hasProtocol) {
            if ((start = url.indexOf(47, start)) == -1) {
                resourceName.append('/');
            } else {
                this.cleanResourceName(url, resourceName, start);
            }
        } else {
            this.cleanResourceName(url, resourceName, start);
        }
        return resourceName.toString();
    }

    private void cleanResourceName(String url, StringBuilder resourceName, int start) {
        boolean lastSegment = false;
        int i = start;
        while (i < url.length() && !lastSegment) {
            int segmentEnd;
            if (url.charAt(i) == '/') {
                resourceName.append('/');
                ++i;
            }
            if ((segmentEnd = url.indexOf(47, i)) == -1) {
                segmentEnd = url.indexOf(63, i);
                if (segmentEnd == -1 && (segmentEnd = url.indexOf(35, i)) == -1) {
                    segmentEnd = url.length();
                }
                lastSegment = true;
            }
            if (i < segmentEnd) {
                int snapshot = resourceName.length();
                char c = url.charAt(i);
                resourceName.append(c);
                boolean isVersion = !lastSegment & (c == 'v' | c == 'V') & segmentEnd - i <= 3;
                boolean containsNumerics = Character.isDigit(c);
                boolean isBlank = Character.isWhitespace(c);
                for (int j = i + 1; j < segmentEnd && (!containsNumerics || isVersion || isBlank); isVersion &= Character.isDigit(c), containsNumerics |= Character.isDigit(c), isBlank &= Character.isWhitespace(c), ++j) {
                    c = url.charAt(j);
                    resourceName.append(c);
                }
                if (containsNumerics && !isVersion) {
                    resourceName.setLength(snapshot);
                    resourceName.append('?');
                } else if (isBlank) {
                    resourceName.setLength(snapshot);
                }
            }
            i = segmentEnd;
        }
        if (resourceName.length() == 0) {
            resourceName.append('/');
        }
    }

    private static int protocolPosition(String url) {
        return PROTOCOL_SEARCH.indexOf(url, 0, 16);
    }

    private static class BitSlicedBitapSearch {
        private final int[] high;
        private final int[] low;
        private final int termination;

        BitSlicedBitapSearch(String term) {
            if (term.length() > 32) {
                throw new IllegalArgumentException("term must be shorter than 32 characters");
            }
            this.high = new int[16];
            this.low = new int[16];
            int mask = 1;
            for (char c : term.toCharArray()) {
                if (c >= '\u0100') {
                    throw new IllegalStateException("term must be latin 1");
                }
                int n = c & 0xF;
                this.low[n] = this.low[n] | mask;
                int n2 = c >>> 4 & 0xF;
                this.high[n2] = this.high[n2] | mask;
                mask <<= 1;
            }
            this.termination = 1 << term.length() - 1;
        }

        public int indexOf(String text, int from, int to) {
            int state = 0;
            to = Math.min(to, text.length());
            for (int i = from; i < to; ++i) {
                char c = text.charAt(i);
                if (c >= '\u0100') {
                    state = 0;
                    continue;
                }
                int highMask = this.high[c >>> 4 & 0xF];
                int lowMask = this.low[c & 0xF];
                if (((state = (state << 1 | 1) & highMask & lowMask) & this.termination) != this.termination) continue;
                return i - Long.numberOfTrailingZeros(this.termination);
            }
            return -1;
        }
    }
}

