/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;

public class BitriseInfo
extends CIProviderInfo {
    public static final String BITRISE = "BITRISE_BUILD_SLUG";
    public static final String BITRISE_PROVIDER_NAME = "bitrise";
    public static final String BITRISE_PIPELINE_ID = "BITRISE_BUILD_SLUG";
    public static final String BITRISE_PIPELINE_NAME = "BITRISE_APP_TITLE";
    public static final String BITRISE_PIPELINE_NUMBER = "BITRISE_BUILD_NUMBER";
    public static final String BITRISE_PIPELINE_URL = "BITRISE_BUILD_URL";
    public static final String BITRISE_WORKSPACE_PATH = "BITRISE_SOURCE_DIR";
    public static final String BITRISE_GIT_REPOSITORY_URL = "GIT_REPOSITORY_URL";
    public static final String BITRISE_GIT_PR_COMMIT = "BITRISE_GIT_COMMIT";
    public static final String BITRISE_GIT_COMMIT = "GIT_CLONE_COMMIT_HASH";
    public static final String BITRISE_GIT_PR_BRANCH = "BITRISEIO_GIT_BRANCH_DEST";
    public static final String BITRISE_GIT_BRANCH = "BITRISE_GIT_BRANCH";
    public static final String BITRISE_GIT_TAG = "BITRISE_GIT_TAG";

    BitriseInfo() {
        String gitTag = this.normalizeRef(System.getenv(BITRISE_GIT_TAG));
        this.ciTags = new CIProviderInfo.CITagsBuilder().withCiProviderName(BITRISE_PROVIDER_NAME).withCiPipelineId(System.getenv("BITRISE_BUILD_SLUG")).withCiPipelineName(System.getenv(BITRISE_PIPELINE_NAME)).withCiPipelineNumber(System.getenv(BITRISE_PIPELINE_NUMBER)).withCiPipelineUrl(System.getenv(BITRISE_PIPELINE_URL)).withCiWorkspacePath(this.expandTilde(System.getenv(BITRISE_WORKSPACE_PATH))).withGitRepositoryUrl(this.filterSensitiveInfo(System.getenv(BITRISE_GIT_REPOSITORY_URL))).withGitCommit(this.buildGitCommit()).withGitBranch(this.buildGitBranch(gitTag)).withGitTag(gitTag).build();
    }

    private String buildGitBranch(String gitTag) {
        if (gitTag != null) {
            return null;
        }
        String fromBranch = System.getenv(BITRISE_GIT_PR_BRANCH);
        if (fromBranch != null && !fromBranch.isEmpty()) {
            return this.normalizeRef(fromBranch);
        }
        return this.normalizeRef(System.getenv(BITRISE_GIT_BRANCH));
    }

    private String buildGitCommit() {
        String fromCommit = System.getenv(BITRISE_GIT_PR_COMMIT);
        if (fromCommit != null && !fromCommit.isEmpty()) {
            return fromCommit;
        }
        return System.getenv(BITRISE_GIT_COMMIT);
    }
}

