/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.AppVeyorInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.AzurePipelinesInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.BitBucketInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.BitriseInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.BuildkiteInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.CircleCIInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.GitLabInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.GithubActionsInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.JenkinsInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.NoopCIInfo;
import datadog.trace.bootstrap.instrumentation.api.ci.TravisInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public abstract class CIProviderInfo {
    protected Map<String, String> ciTags = new HashMap<String, String>();

    public boolean isCI() {
        return true;
    }

    public Map<String, String> getCiTags() {
        return this.ciTags;
    }

    public static CIProviderInfo selectCI() {
        if (System.getenv("JENKINS_URL") != null) {
            return new JenkinsInfo();
        }
        if (System.getenv("GITLAB_CI") != null) {
            return new GitLabInfo();
        }
        if (System.getenv("TRAVIS") != null) {
            return new TravisInfo();
        }
        if (System.getenv("CIRCLECI") != null) {
            return new CircleCIInfo();
        }
        if (System.getenv("APPVEYOR") != null) {
            return new AppVeyorInfo();
        }
        if (System.getenv("TF_BUILD") != null) {
            return new AzurePipelinesInfo();
        }
        if (System.getenv("BITBUCKET_COMMIT") != null) {
            return new BitBucketInfo();
        }
        if (System.getenv("GITHUB_ACTION") != null) {
            return new GithubActionsInfo();
        }
        if (System.getenv("BUILDKITE") != null) {
            return new BuildkiteInfo();
        }
        if (System.getenv("BITRISE_BUILD_SLUG") != null) {
            return new BitriseInfo();
        }
        return new NoopCIInfo();
    }

    protected String expandTilde(String path) {
        if (path == null || path.isEmpty() || !path.startsWith("~")) {
            return path;
        }
        if (!path.equals("~") && !path.startsWith("~/")) {
            return path;
        }
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    protected String normalizeRef(String rawRef) {
        if (rawRef == null || rawRef.isEmpty()) {
            return null;
        }
        String ref = rawRef;
        if (ref.startsWith("origin")) {
            ref = ref.replace("origin/", "");
        } else if (ref.startsWith("refs/heads")) {
            ref = ref.replace("refs/heads/", "");
        }
        if (ref.startsWith("tags")) {
            return ref.replace("tags/", "");
        }
        return ref;
    }

    protected String filterSensitiveInfo(String urlStr) {
        if (urlStr == null || urlStr.isEmpty()) {
            return null;
        }
        try {
            URI url = new URI(urlStr);
            String userInfo = url.getRawUserInfo();
            return urlStr.replace(userInfo + "@", "");
        }
        catch (URISyntaxException ex) {
            return urlStr;
        }
    }

    public static class CITagsBuilder {
        private final Map<String, String> ciTags = new HashMap<String, String>();

        public CITagsBuilder withCiProviderName(String ciProviderName) {
            if (ciProviderName != null) {
                this.ciTags.put("ci.provider.name", ciProviderName);
            }
            return this;
        }

        public CITagsBuilder withCiPipelineId(String ciPipelineId) {
            if (ciPipelineId != null) {
                this.ciTags.put("ci.pipeline.id", ciPipelineId);
            }
            return this;
        }

        public CITagsBuilder withCiPipelineName(String ciPipelineName) {
            if (ciPipelineName != null) {
                this.ciTags.put("ci.pipeline.name", ciPipelineName);
            }
            return this;
        }

        public CITagsBuilder withCiPipelineNumber(String ciPipelineNumber) {
            if (ciPipelineNumber != null) {
                this.ciTags.put("ci.pipeline.number", ciPipelineNumber);
            }
            return this;
        }

        public CITagsBuilder withCiPipelineUrl(String ciPipelineUrl) {
            if (ciPipelineUrl != null) {
                this.ciTags.put("ci.pipeline.url", ciPipelineUrl);
            }
            return this;
        }

        public CITagsBuilder withCiStageName(String ciStageName) {
            if (ciStageName != null) {
                this.ciTags.put("ci.stage.name", ciStageName);
            }
            return this;
        }

        public CITagsBuilder withCiJobName(String ciJobName) {
            if (ciJobName != null) {
                this.ciTags.put("ci.job.name", ciJobName);
            }
            return this;
        }

        public CITagsBuilder withCiJorUrl(String ciJobUrl) {
            if (ciJobUrl != null) {
                this.ciTags.put("ci.job.url", ciJobUrl);
            }
            return this;
        }

        public CITagsBuilder withCiWorkspacePath(String ciWorkspacePath) {
            if (ciWorkspacePath != null) {
                this.ciTags.put("ci.workspace_path", ciWorkspacePath);
            }
            return this;
        }

        public CITagsBuilder withGitRepositoryUrl(String gitRepositoryUrl) {
            if (gitRepositoryUrl != null) {
                this.ciTags.put("git.repository_url", gitRepositoryUrl);
            }
            return this;
        }

        public CITagsBuilder withGitCommit(String gitCommit) {
            if (gitCommit != null) {
                this.ciTags.put("git.commit.sha", gitCommit);
            }
            return this;
        }

        public CITagsBuilder withGitBranch(String gitBranch) {
            if (gitBranch != null) {
                this.ciTags.put("git.branch", gitBranch);
            }
            return this;
        }

        public CITagsBuilder withGitTag(String gitTag) {
            if (gitTag != null) {
                this.ciTags.put("git.tag", gitTag);
            }
            return this;
        }

        public Map<String, String> build() {
            return this.ciTags;
        }
    }
}

