/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;

class GitLabInfo
extends CIProviderInfo {
    public static final String GITLAB = "GITLAB_CI";
    public static final String GITLAB_PROVIDER_NAME = "gitlab";
    public static final String GITLAB_PIPELINE_ID = "CI_PIPELINE_ID";
    public static final String GITLAB_PIPELINE_NAME = "CI_PROJECT_PATH";
    public static final String GITLAB_PIPELINE_NUMBER = "CI_PIPELINE_IID";
    public static final String GITLAB_PIPELINE_URL = "CI_PIPELINE_URL";
    public static final String GITLAB_STAGE_NAME = "CI_JOB_STAGE";
    public static final String GITLAB_JOB_NAME = "CI_JOB_NAME";
    public static final String GITLAB_JOB_URL = "CI_JOB_URL";
    public static final String GITLAB_WORKSPACE_PATH = "CI_PROJECT_DIR";
    public static final String GITLAB_GIT_REPOSITORY_URL = "CI_REPOSITORY_URL";
    public static final String GITLAB_GIT_COMMIT = "CI_COMMIT_SHA";
    public static final String GITLAB_GIT_BRANCH = "CI_COMMIT_BRANCH";
    public static final String GITLAB_GIT_TAG = "CI_COMMIT_TAG";

    GitLabInfo() {
        this.ciTags = new CIProviderInfo.CITagsBuilder().withCiProviderName(GITLAB_PROVIDER_NAME).withCiPipelineId(System.getenv(GITLAB_PIPELINE_ID)).withCiPipelineName(System.getenv(GITLAB_PIPELINE_NAME)).withCiPipelineNumber(System.getenv(GITLAB_PIPELINE_NUMBER)).withCiPipelineUrl(this.buildPipelineUrl()).withCiStageName(System.getenv(GITLAB_STAGE_NAME)).withCiJobName(System.getenv(GITLAB_JOB_NAME)).withCiJorUrl(System.getenv(GITLAB_JOB_URL)).withCiWorkspacePath(this.expandTilde(System.getenv(GITLAB_WORKSPACE_PATH))).withGitRepositoryUrl(this.filterSensitiveInfo(System.getenv(GITLAB_GIT_REPOSITORY_URL))).withGitCommit(System.getenv(GITLAB_GIT_COMMIT)).withGitBranch(this.normalizeRef(System.getenv(GITLAB_GIT_BRANCH))).withGitTag(this.normalizeRef(System.getenv(GITLAB_GIT_TAG))).build();
    }

    private String buildPipelineUrl() {
        String pipelineUrl = System.getenv(GITLAB_PIPELINE_URL);
        if (pipelineUrl == null || pipelineUrl.isEmpty()) {
            return null;
        }
        return pipelineUrl.replace("/-/pipelines/", "/pipelines/");
    }
}

