/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;

public final class MetricKey {
    private final UTF8BytesString resource;
    private final UTF8BytesString service;
    private final UTF8BytesString operationName;
    private final UTF8BytesString type;
    private final int httpStatusCode;
    private final int hash;

    public MetricKey(CharSequence resource, CharSequence service, CharSequence operationName, CharSequence type, int httpStatusCode) {
        this.resource = null == resource ? UTF8BytesString.EMPTY : UTF8BytesString.create(resource);
        this.service = null == service ? UTF8BytesString.EMPTY : UTF8BytesString.create(service);
        this.operationName = null == operationName ? UTF8BytesString.EMPTY : UTF8BytesString.create(operationName);
        this.type = null == type ? UTF8BytesString.EMPTY : UTF8BytesString.create(type);
        this.httpStatusCode = httpStatusCode;
        this.hash = 923521 * this.resource.hashCode() + 29791 * this.service.hashCode() + 961 * this.operationName.hashCode() + 31 * this.type.hashCode() + httpStatusCode;
    }

    public UTF8BytesString getResource() {
        return this.resource;
    }

    public UTF8BytesString getService() {
        return this.service;
    }

    public UTF8BytesString getOperationName() {
        return this.operationName;
    }

    public UTF8BytesString getType() {
        return this.type;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public boolean equals(Object o) {
        try {
            MetricKey metricKey = (MetricKey)o;
            return this.hash == metricKey.hash && this.httpStatusCode == metricKey.httpStatusCode && this.resource.equals(metricKey.resource) && this.service.equals(metricKey.service) && this.operationName.equals(metricKey.operationName) && this.type.equals(metricKey.type);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.hash;
    }
}

