/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.core.monitor.Recording;
import datadog.trace.core.monitor.Utils;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.PackedHistogram;

public class Timer
extends Recording {
    private static final long THIRTY_SECONDS_AS_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private static final String[] MEAN = new String[]{"stat:avg"};
    private static final String[] P_50 = new String[]{"stat:p50"};
    private static final String[] P_99 = new String[]{"stat:p99"};
    private static final String[] MAX = new String[]{"stat:max"};
    private final String name;
    private final StatsDClient statsd;
    private final PackedHistogram histogram;
    private final long flushAfterNanos;
    private final String[] meanTags;
    private final String[] p50Tags;
    private final String[] p99Tags;
    private final String[] maxTags;
    private long start;
    private long lastFlush = 0L;

    Timer(String name, String[] tags, StatsDClient statsd, long flushAfterNanos) {
        this.name = name;
        this.statsd = statsd;
        this.flushAfterNanos = flushAfterNanos;
        this.histogram = new PackedHistogram(THIRTY_SECONDS_AS_NANOS, 3);
        this.meanTags = Utils.mergeTags(MEAN, tags);
        this.p50Tags = Utils.mergeTags(P_50, tags);
        this.p99Tags = Utils.mergeTags(P_99, tags);
        this.maxTags = Utils.mergeTags(MAX, tags);
    }

    Timer(String name, StatsDClient statsd, long flushAfterNanos) {
        this(name, null, statsd, flushAfterNanos);
    }

    @Override
    public Recording start() {
        this.start = System.nanoTime();
        return this;
    }

    @Override
    public void reset() {
        long now = System.nanoTime();
        this.record(now);
        this.start = now;
    }

    @Override
    public void stop() {
        this.record(System.nanoTime());
    }

    private void record(long now) {
        this.histogram.recordValue(Math.min(now - this.start, THIRTY_SECONDS_AS_NANOS));
        if (now - this.lastFlush > this.flushAfterNanos) {
            this.lastFlush = now;
            this.flush();
        }
    }

    @Override
    public void flush() {
        this.statsd.gauge(this.name, (long)this.histogram.getMean(), this.meanTags);
        this.statsd.gauge(this.name, this.histogram.getValueAtPercentile(50.0), this.p50Tags);
        this.statsd.gauge(this.name, this.histogram.getValueAtPercentile(99.0), this.p99Tags);
        this.statsd.gauge(this.name, this.histogram.getMaxValue(), this.maxTags);
        this.histogram.reset();
    }
}

