/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.api.Config;
import datadog.trace.api.WellKnownTags;
import datadog.trace.common.metrics.Aggregator;
import datadog.trace.common.metrics.Batch;
import datadog.trace.common.metrics.EventListener;
import datadog.trace.common.metrics.MetricKey;
import datadog.trace.common.metrics.MetricWriter;
import datadog.trace.common.metrics.MetricsAggregator;
import datadog.trace.common.metrics.OkHttpSink;
import datadog.trace.common.metrics.SerializingMetricWriter;
import datadog.trace.common.metrics.Sink;
import datadog.trace.core.CoreSpan;
import datadog.trace.util.AgentThreadFactory;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.MpscBlockingConsumerArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConflatingMetricsAggregator
implements MetricsAggregator,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(ConflatingMetricsAggregator.class);
    private static final Integer ZERO = 0;
    static final Batch POISON_PILL = Batch.NULL;
    private final Queue<Batch> batchPool;
    private final ConcurrentHashMap<MetricKey, Batch> pending;
    private final Thread thread;
    private final BlockingQueue<Batch> inbox;
    private final Sink sink;
    private final Aggregator aggregator;
    private volatile boolean enabled = true;

    public ConflatingMetricsAggregator(Config config) {
        this(config.getWellKnownTags(), new OkHttpSink(config.getAgentUrl(), config.getAgentTimeout(), config.isTracerMetricsBufferingEnabled()), config.getTracerMetricsMaxAggregates(), config.getTracerMetricsMaxPending());
    }

    ConflatingMetricsAggregator(WellKnownTags wellKnownTags, Sink sink, int maxAggregates, int queueSize) {
        this(wellKnownTags, sink, maxAggregates, queueSize, 10L, TimeUnit.SECONDS);
    }

    ConflatingMetricsAggregator(WellKnownTags wellKnownTags, Sink sink, int maxAggregates, int queueSize, long reportingInterval, TimeUnit timeUnit) {
        this(sink, new SerializingMetricWriter(wellKnownTags, sink), maxAggregates, queueSize, reportingInterval, timeUnit);
    }

    ConflatingMetricsAggregator(Sink sink, MetricWriter metricWriter, int maxAggregates, int queueSize, long reportingInterval, TimeUnit timeUnit) {
        this.inbox = new MpscBlockingConsumerArrayQueue(queueSize);
        this.batchPool = new MpmcArrayQueue(maxAggregates);
        this.pending = new ConcurrentHashMap(maxAggregates * 4 / 3, 0.75f);
        this.sink = sink;
        this.aggregator = new Aggregator(metricWriter, this.batchPool, this.inbox, this.pending, maxAggregates, reportingInterval, timeUnit);
        this.thread = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.METRICS_AGGREGATOR, this.aggregator);
    }

    @Override
    public void start() {
        this.sink.register(this);
        this.thread.start();
    }

    @Override
    public void publish(List<? extends CoreSpan<?>> trace) {
        if (this.enabled) {
            for (CoreSpan<?> span : trace) {
                if (!span.isTopLevel() && !span.isMeasured()) continue;
                this.publish(span);
            }
        }
    }

    private void publish(CoreSpan<?> span) {
        MetricKey key = new MetricKey(span.getResourceName(), span.getServiceName(), span.getOperationName(), span.getType(), span.getTag("http.status_code", ZERO));
        long tag = span.getError() > 0 ? Long.MIN_VALUE : 0L;
        long durationNanos = span.getDurationNano();
        Batch batch = this.pending.get(key);
        if (null != batch) {
            if (batch.add(tag, durationNanos)) {
                return;
            }
            key = batch.getKey();
        }
        batch = this.newBatch(key);
        batch.add(tag, durationNanos);
        this.pending.put(key, batch);
        this.inbox.offer(batch);
    }

    private Batch newBatch(MetricKey key) {
        Batch batch = this.batchPool.poll();
        if (null == batch) {
            return new Batch(key);
        }
        return batch.reset(key);
    }

    public void stop() {
        this.inbox.offer(POISON_PILL);
    }

    @Override
    public void close() {
        this.stop();
        try {
            this.thread.join(800L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void onEvent(EventListener.EventType eventType, String message) {
        switch (eventType) {
            case DOWNGRADED: {
                log.debug("Disabling metric reporting because an agent downgrade was detected");
                this.disable();
                break;
            }
            case BAD_PAYLOAD: {
                log.debug("bad metrics payload sent to trace agent: {}", (Object)message);
                break;
            }
            case ERROR: {
                log.debug("trace agent errored receiving metrics payload: {}", (Object)message);
                break;
            }
        }
    }

    private void disable() {
        this.enabled = false;
        this.thread.interrupt();
        this.pending.clear();
        this.batchPool.clear();
        this.inbox.clear();
        this.aggregator.clearAggregates();
    }
}

