/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.api.WellKnownTags;
import datadog.trace.common.metrics.AggregateMetric;
import datadog.trace.common.metrics.MetricKey;
import datadog.trace.common.metrics.MetricWriter;
import datadog.trace.common.metrics.Sink;
import datadog.trace.core.serialization.ByteBufferConsumer;
import datadog.trace.core.serialization.Mapper;
import datadog.trace.core.serialization.Writable;
import datadog.trace.core.serialization.WritableFormatter;
import datadog.trace.core.serialization.msgpack.MsgPackWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializingMetricWriter
implements MetricWriter {
    private static final Logger log = LoggerFactory.getLogger(SerializingMetricWriter.class);
    private static final byte[] HOSTNAME = "Hostname".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] NAME = "Name".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ENV = "Env".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SERVICE = "Service".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] RESOURCE = "Resource".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] VERSION = "Version".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HITS = "Hits".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ERRORS = "Errors".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] DURATION = "Duration".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TYPE = "Type".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HTTP_STATUS_CODE = "HTTPStatusCode".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] START = "Start".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] STATS = "Stats".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] OK_SUMMARY = "OkSummary".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ERROR_SUMMARY = "ErrorSummary".getBytes(StandardCharsets.ISO_8859_1);
    private final WellKnownTags wellKnownTags;
    private final WritableFormatter writer;

    public SerializingMetricWriter(WellKnownTags wellKnownTags, Sink sink) {
        this.wellKnownTags = wellKnownTags;
        this.writer = new MsgPackWriter((ByteBufferConsumer)sink, ByteBuffer.allocate(0x100000), EnumSet.of(WritableFormatter.Feature.SINGLE_MESSAGE));
    }

    @Override
    public void startBucket(int metricCount, long start, long duration) {
        this.writer.startMap(4);
        this.writer.writeUTF8(HOSTNAME);
        this.writer.writeUTF8(this.wellKnownTags.getHostname());
        this.writer.writeUTF8(ENV);
        this.writer.writeUTF8(this.wellKnownTags.getEnv());
        this.writer.writeUTF8(VERSION);
        this.writer.writeUTF8(this.wellKnownTags.getVersion());
        this.writer.writeUTF8(STATS);
        this.writer.startArray(1);
        this.writer.startMap(3);
        this.writer.writeUTF8(START);
        this.writer.writeLong(start);
        this.writer.writeUTF8(DURATION);
        this.writer.writeLong(duration);
        this.writer.writeUTF8(STATS);
        this.writer.startArray(metricCount);
    }

    @Override
    public void add(MetricKey key, AggregateMetric aggregate) {
        this.writer.format(new Metric(key, aggregate), new Mapper<Metric>(){

            @Override
            public void map(Metric metric, Writable writer) {
                writer.startMap(10);
                writer.writeUTF8(NAME);
                writer.writeUTF8(metric.key.getOperationName());
                writer.writeUTF8(SERVICE);
                writer.writeUTF8(metric.key.getService());
                writer.writeUTF8(RESOURCE);
                writer.writeUTF8(metric.key.getResource());
                writer.writeUTF8(TYPE);
                writer.writeUTF8(metric.key.getType());
                writer.writeUTF8(HTTP_STATUS_CODE);
                writer.writeInt(metric.key.getHttpStatusCode());
                writer.writeUTF8(HITS);
                writer.writeInt(metric.aggregate.getHitCount());
                writer.writeUTF8(ERRORS);
                writer.writeInt(metric.aggregate.getErrorCount());
                writer.writeUTF8(DURATION);
                writer.writeLong(metric.aggregate.getDuration());
                writer.writeUTF8(OK_SUMMARY);
                writer.writeBinary(metric.aggregate.getOkLatencies().serialize());
                writer.writeUTF8(ERROR_SUMMARY);
                writer.writeBinary(metric.aggregate.getErrorLatencies().serialize());
            }
        });
    }

    @Override
    public void finishBucket() {
        this.writer.flush();
    }

    private static final class Metric {
        private final MetricKey key;
        private final AggregateMetric aggregate;

        private Metric(MetricKey key, AggregateMetric aggregate) {
            this.key = key;
            this.aggregate = aggregate;
        }
    }
}

