/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.core.PendingTrace;
import datadog.trace.util.AgentThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscBlockingConsumerArrayQueue;

public abstract class PendingTraceBuffer
implements AutoCloseable {
    private static final int BUFFER_SIZE = 4096;

    public static PendingTraceBuffer delaying() {
        return new DelayingPendingTraceBuffer(4096);
    }

    public static PendingTraceBuffer mute() {
        return new MutePendingTraceBuffer();
    }

    public abstract void start();

    @Override
    public abstract void close();

    public abstract void flush();

    public abstract void enqueue(PendingTrace var1);

    static class MutePendingTraceBuffer
    extends PendingTraceBuffer {
        MutePendingTraceBuffer() {
        }

        @Override
        public void start() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void enqueue(PendingTrace pendingTrace) {
        }
    }

    private static class DelayingPendingTraceBuffer
    extends PendingTraceBuffer {
        private static final long FORCE_SEND_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
        private static final long SEND_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(500L);
        private static final long SLEEP_TIME_MS = 100L;
        private final MpscBlockingConsumerArrayQueue<PendingTrace> queue;
        private final Thread worker;
        private volatile boolean closed = false;

        @Override
        public void enqueue(PendingTrace pendingTrace) {
            if (!this.queue.offer((Object)pendingTrace)) {
                pendingTrace.write();
            }
        }

        @Override
        public void start() {
            this.worker.start();
        }

        @Override
        public void close() {
            this.closed = true;
            this.worker.interrupt();
            try {
                this.worker.join(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
            this.queue.drain((MessagePassingQueue.Consumer)WriteDrain.WRITE_DRAIN);
        }

        public DelayingPendingTraceBuffer(int bufferSize) {
            this.queue = new MpscBlockingConsumerArrayQueue(bufferSize);
            this.worker = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.TRACE_MONITOR, new Worker());
        }

        private final class Worker
        implements Runnable {
            private Worker() {
            }

            @Override
            public void run() {
                try {
                    while (!DelayingPendingTraceBuffer.this.closed && !Thread.currentThread().isInterrupted()) {
                        PendingTrace pendingTrace = (PendingTrace)DelayingPendingTraceBuffer.this.queue.take();
                        long oldestFinishedTime = pendingTrace.oldestFinishedTime();
                        long finishTimestampMillis = TimeUnit.NANOSECONDS.toMillis(oldestFinishedTime);
                        if (finishTimestampMillis <= System.currentTimeMillis() - FORCE_SEND_DELAY_MS) {
                            pendingTrace.write();
                            continue;
                        }
                        if (pendingTrace.lastReferencedNanosAgo(SEND_DELAY_NS)) {
                            pendingTrace.write();
                            continue;
                        }
                        DelayingPendingTraceBuffer.this.enqueue(pendingTrace);
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static final class WriteDrain
        implements MessagePassingQueue.Consumer<PendingTrace> {
            private static final WriteDrain WRITE_DRAIN = new WriteDrain();

            private WriteDrain() {
            }

            public void accept(PendingTrace pendingTrace) {
                pendingTrace.write();
            }
        }
    }
}

