/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDTags;
import datadog.trace.bootstrap.instrumentation.api.InstrumentationTags;
import datadog.trace.bootstrap.instrumentation.api.Tags;
import datadog.trace.core.DDSpanContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class StringTables {
    public static final byte[] SERVICE = "service".getBytes(StandardCharsets.UTF_8);
    public static final byte[] NAME = "name".getBytes(StandardCharsets.UTF_8);
    public static final byte[] RESOURCE = "resource".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TRACE_ID = "trace_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] SPAN_ID = "span_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] PARENT_ID = "parent_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] START = "start".getBytes(StandardCharsets.UTF_8);
    public static final byte[] DURATION = "duration".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TYPE = "type".getBytes(StandardCharsets.UTF_8);
    public static final byte[] ERROR = "error".getBytes(StandardCharsets.UTF_8);
    public static final byte[] METRICS = "metrics".getBytes(StandardCharsets.UTF_8);
    public static final byte[] META = "meta".getBytes(StandardCharsets.UTF_8);
    private static final Map<CharSequence, byte[]> UTF8_INTERN_KEYS_TABLE = new HashMap<CharSequence, byte[]>(256);

    public static byte[] getKeyBytesUTF8(CharSequence value) {
        return UTF8_INTERN_KEYS_TABLE.get(value);
    }

    private static void internConstantsUTF8(Class<?> clazz, Map<CharSequence, byte[]> map) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || field.getType() != String.class) continue;
            try {
                StringTables.intern(map, (String)field.get(null), StandardCharsets.UTF_8);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static void intern(Map<CharSequence, byte[]> table, String value, Charset encoding) {
        byte[] bytes = value.getBytes(encoding);
        table.put(value, bytes);
    }

    static {
        StringTables.internConstantsUTF8(DDSpanContext.class, UTF8_INTERN_KEYS_TABLE);
        StringTables.internConstantsUTF8(DDTags.class, UTF8_INTERN_KEYS_TABLE);
        StringTables.internConstantsUTF8(Tags.class, UTF8_INTERN_KEYS_TABLE);
        StringTables.internConstantsUTF8(InstrumentationTags.class, UTF8_INTERN_KEYS_TABLE);
        StringTables.intern(UTF8_INTERN_KEYS_TABLE, "_dd.agent_psr", StandardCharsets.UTF_8);
    }
}

