/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.histogram;

import datadog.trace.api.Platform;
import datadog.trace.core.histogram.HistogramFactory;
import datadog.trace.core.histogram.StubHistogram;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Histograms {
    private static final Logger log = LoggerFactory.getLogger(Histograms.class);
    private final boolean loadStub;
    private static final Histograms INSTANCE = new Histograms(!Platform.isJavaVersionAtLeast(8));

    public Histograms(boolean loadStub) {
        this.loadStub = loadStub;
    }

    HistogramFactory newFactory() {
        if (this.loadStub) {
            return Histograms.load("datadog.trace.core.histogram.StubHistogram");
        }
        return Histograms.load("datadog.trace.core.histogram.DDSketchHistogramFactory");
    }

    public static HistogramFactory newHistogramFactory() {
        return INSTANCE.newFactory();
    }

    private static HistogramFactory load(String name) {
        try {
            return (HistogramFactory)Class.forName(name).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.debug("Failed to load {}", (Object)name, (Object)e);
            return new StubHistogram();
        }
    }
}

