/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.common.metrics.AggregateMetric;
import datadog.trace.common.metrics.MetricKey;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;

public final class Batch {
    private static final int MAX_BATCH_SIZE = 64;
    static final Batch NULL = new Batch((AtomicLongArray)null);
    static final Batch REPORT = new Batch((AtomicLongArray)null);
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicInteger committed = new AtomicInteger(0);
    private MetricKey key;
    private final AtomicLongArray durations;

    Batch(MetricKey key) {
        this(new AtomicLongArray(64));
        this.key = key;
    }

    Batch() {
        this(new AtomicLongArray(64));
    }

    private Batch(AtomicLongArray durations) {
        this.durations = durations;
    }

    public MetricKey getKey() {
        return this.key;
    }

    public Batch reset(MetricKey key) {
        this.key = key;
        this.count.set(0);
        return this;
    }

    public boolean isUsed() {
        return this.count.get() < 0;
    }

    public boolean add(long tag, long durationNanos) {
        int position = this.count.getAndIncrement();
        if (position >= 0 && position < this.durations.length()) {
            this.durations.set(position, tag | durationNanos);
            this.committed.incrementAndGet();
            return true;
        }
        return false;
    }

    public void contributeTo(AggregateMetric aggregate) {
        int count = Math.min(this.count.getAndSet(Integer.MIN_VALUE), 64);
        if (count >= 0) {
            while (this.committed.get() != count) {
                Thread.yield();
            }
            this.committed.set(0);
            aggregate.recordDurations(count, this.durations);
        }
    }
}

