/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.common.writer.DDSpanJsonAdapter;
import datadog.trace.common.writer.Writer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.TraceProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class PrintingWriter
implements Writer {
    private final TraceProcessor processor = new TraceProcessor();
    private final BufferedSink sink;
    private final JsonAdapter<Map<String, List<List<DDSpan>>>> jsonAdapter;

    public PrintingWriter(OutputStream outputStream, boolean hexIds) {
        this.sink = Okio.buffer((Sink)Okio.sink((OutputStream)outputStream));
        this.jsonAdapter = new Moshi.Builder().add(DDSpanJsonAdapter.buildFactory(hexIds)).build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Types.newParameterizedType(List.class, (Type[])new Type[]{Types.newParameterizedType(List.class, (Type[])new Type[]{DDSpan.class})})}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(List<DDSpan> trace) {
        List<DDSpan> processedTrace = this.processor.onTraceComplete(trace);
        List<List<DDSpan>> tracesList = Collections.singletonList(processedTrace);
        try {
            BufferedSink bufferedSink = this.sink;
            synchronized (bufferedSink) {
                this.jsonAdapter.toJson(this.sink, Collections.singletonMap("traces", tracesList));
                this.sink.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean flush() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void incrementTraceCount() {
    }
}

