/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import okhttp3.RequestBody;

public abstract class Payload {
    private static final ByteBuffer EMPTY_ARRAY = ByteBuffer.allocate(1).put(0, (byte)-112);
    private int traceCount = 0;
    protected ByteBuffer body = EMPTY_ARRAY.duplicate();

    public Payload withBody(int traceCount, ByteBuffer body) {
        this.traceCount = traceCount;
        if (null != body) {
            this.body = body;
        }
        return this;
    }

    int traceCount() {
        return this.traceCount;
    }

    abstract int sizeInBytes();

    abstract void writeTo(WritableByteChannel var1) throws IOException;

    abstract RequestBody toRequest();

    protected int msgpackArrayHeaderSize(int count) {
        if (count < 16) {
            return 1;
        }
        if (count < 65536) {
            return 3;
        }
        return 5;
    }

    protected ByteBuffer msgpackArrayHeader(int count) {
        if (count < 16) {
            return ByteBuffer.allocate(1).put(0, (byte)(0x90 | count));
        }
        if (count < 65536) {
            return ByteBuffer.allocate(3).put(0, (byte)-36).putShort(1, (short)count);
        }
        return ByteBuffer.allocate(5).put(0, (byte)-35).putInt(1, count);
    }
}

