/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.histogram;

import com.datadoghq.sketch.ddsketch.DDSketch;
import com.datadoghq.sketch.ddsketch.mapping.BitwiseLinearlyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import com.datadoghq.sketch.ddsketch.store.PaginatedStore;
import datadog.trace.core.histogram.Histogram;
import datadog.trace.core.histogram.HistogramFactory;
import java.nio.ByteBuffer;

public final class DDSketchHistogram
implements Histogram,
HistogramFactory {
    private final DDSketch sketch;

    public DDSketchHistogram() {
        this(new DDSketch((IndexMapping)new BitwiseLinearlyInterpolatedMapping(0.01), PaginatedStore::new));
    }

    public DDSketchHistogram(DDSketch sketch) {
        this.sketch = sketch;
    }

    @Override
    public void accept(long value) {
        this.sketch.accept((double)value);
    }

    @Override
    public double valueAtQuantile(double quantile) {
        if (this.sketch.isEmpty()) {
            return 0.0;
        }
        return this.sketch.getValueAtQuantile(quantile);
    }

    @Override
    public double max() {
        if (this.sketch.isEmpty()) {
            return 0.0;
        }
        return this.sketch.getMaxValue();
    }

    @Override
    public void clear() {
        this.sketch.clear();
    }

    @Override
    public ByteBuffer serialize() {
        return this.sketch.serialize();
    }

    @Override
    public Histogram newHistogram() {
        return new DDSketchHistogram();
    }
}

