/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.common.writer.DDSpanJsonAdapter;
import datadog.trace.common.writer.Writer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.TraceProcessor;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(LoggingWriter.class);
    private static final JsonAdapter<List<DDSpan>> TRACE_ADAPTER = new Moshi.Builder().add(DDSpanJsonAdapter.buildFactory(false)).build().adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{DDSpan.class}));
    private final TraceProcessor processor = new TraceProcessor();

    @Override
    public void write(List<DDSpan> trace) {
        List<DDSpan> processedTrace = this.processor.onTraceComplete(trace);
        try {
            log.info("write(trace): {}", (Object)TRACE_ADAPTER.toJson(processedTrace));
        }
        catch (Exception e) {
            log.error("error writing(trace): {}", processedTrace, (Object)e);
        }
    }

    @Override
    public void start() {
        log.info("start()");
    }

    @Override
    public boolean flush() {
        log.info("flush()");
        return true;
    }

    @Override
    public void close() {
        log.info("close()");
    }

    @Override
    public void incrementTraceCount() {
    }

    public String toString() {
        return "LoggingWriter { }";
    }
}

