/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.bootstrap.instrumentation.api.InstrumentationTags;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.Metadata;
import datadog.trace.core.MetadataConsumer;
import datadog.trace.core.http.OkHttpUtils;
import datadog.trace.core.serialization.Util;
import datadog.trace.core.serialization.Writable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import okhttp3.RequestBody;

public final class TraceMapperV0_4
implements TraceMapper {
    public static final byte[] SERVICE = "service".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] NAME = "name".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] RESOURCE = "resource".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] TRACE_ID = "trace_id".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] SPAN_ID = "span_id".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] PARENT_ID = "parent_id".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] START = "start".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] DURATION = "duration".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] TYPE = "type".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] ERROR = "error".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] METRICS = "metrics".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] META = "meta".getBytes(StandardCharsets.ISO_8859_1);
    static final byte[] EMPTY = ByteBuffer.allocate(1).put((byte)-112).array();
    private final MetaWriter metaWriter = new MetaWriter();

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        writable.startArray(trace.size());
        for (CoreSpan<?> span : trace) {
            writable.startMap(12);
            writable.writeUTF8(SERVICE);
            writable.writeString(span.getServiceName(), null);
            writable.writeUTF8(NAME);
            writable.writeObject(span.getOperationName(), null);
            writable.writeUTF8(RESOURCE);
            writable.writeObject(span.getResourceName(), null);
            writable.writeUTF8(TRACE_ID);
            writable.writeLong(span.getTraceId().toLong());
            writable.writeUTF8(SPAN_ID);
            writable.writeLong(span.getSpanId().toLong());
            writable.writeUTF8(PARENT_ID);
            writable.writeLong(span.getParentId().toLong());
            writable.writeUTF8(START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeLong(span.getDurationNano());
            writable.writeUTF8(TYPE);
            writable.writeString(span.getType(), null);
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            TraceMapperV0_4.writeMetrics(span, writable);
            writable.writeUTF8(META);
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable));
        }
    }

    private static void writeMetrics(CoreSpan<?> span, Writable writable) {
        writable.writeUTF8(METRICS);
        Map<CharSequence, Number> metrics = span.getUnsafeMetrics();
        int elementCount = metrics.size();
        elementCount += span.hasSamplingPriority() ? 1 : 0;
        elementCount += span.isMeasured() ? 1 : 0;
        writable.startMap(elementCount += span.isTopLevel() ? 1 : 0);
        if (span.hasSamplingPriority()) {
            writable.writeUTF8(SAMPLING_PRIORITY_KEY);
            writable.writeInt(span.samplingPriority());
        }
        if (span.isMeasured()) {
            writable.writeUTF8(InstrumentationTags.DD_MEASURED);
            writable.writeInt(1);
        }
        if (span.isTopLevel()) {
            writable.writeUTF8(InstrumentationTags.DD_TOP_LEVEL);
            writable.writeInt(1);
        }
        for (Map.Entry<CharSequence, Number> metric : metrics.entrySet()) {
            writable.writeString(metric.getKey(), null);
            writable.writeObject(metric.getValue(), null);
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_4();
    }

    @Override
    public int messageBufferSize() {
        return 0x500000;
    }

    @Override
    public void reset() {
    }

    @Override
    public String endpoint() {
        return "v0.4";
    }

    private static class PayloadV0_4
    extends Payload {
        private PayloadV0_4() {
        }

        @Override
        int sizeInBytes() {
            return this.msgpackArrayHeaderSize(this.traceCount()) + this.body.remaining();
        }

        @Override
        void writeTo(WritableByteChannel channel) throws IOException {
            ByteBuffer header = this.msgpackArrayHeader(this.traceCount());
            while (header.hasRemaining()) {
                channel.write(header);
            }
            while (this.body.hasRemaining()) {
                channel.write(this.body);
            }
        }

        @Override
        RequestBody toRequest() {
            return OkHttpUtils.msgpackRequestBodyOf(Arrays.asList(this.msgpackArrayHeader(this.traceCount()), this.body));
        }
    }

    private static final class MetaWriter
    extends MetadataConsumer {
        private final byte[] numberByteArray = Util.integerToStringBuffer();
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int i;
            int size = metadata.getTags().size() + 2;
            long overlaps = 0L;
            if (!metadata.getBaggage().isEmpty()) {
                i = 0;
                for (Map.Entry<String, String> entry : metadata.getBaggage().entrySet()) {
                    if (!metadata.getTags().containsKey(entry.getKey())) {
                        ++size;
                    } else {
                        overlaps |= 1L << i;
                    }
                    ++i;
                }
            }
            this.writable.startMap(size);
            i = 0;
            for (Map.Entry<String, String> entry : metadata.getBaggage().entrySet()) {
                if ((overlaps & 1L << i) == 0L) {
                    this.writable.writeString(entry.getKey(), null);
                    this.writable.writeString(entry.getValue(), null);
                }
                ++i;
            }
            this.writable.writeUTF8(TraceMapper.THREAD_NAME);
            this.writable.writeUTF8(metadata.getThreadName());
            this.writable.writeUTF8(TraceMapper.THREAD_ID);
            Util.writeLongAsString(metadata.getThreadId(), this.writable, this.numberByteArray);
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                this.writable.writeString(entry.getKey(), null);
                if (entry.getValue() instanceof Long || entry.getValue() instanceof Integer) {
                    Util.writeLongAsString(((Number)entry.getValue()).longValue(), this.writable, this.numberByteArray);
                    continue;
                }
                if (entry.getValue() instanceof UTF8BytesString) {
                    this.writable.writeUTF8((UTF8BytesString)entry.getValue());
                    continue;
                }
                this.writable.writeString(String.valueOf(entry.getValue()), null);
            }
        }
    }
}

