/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.bootstrap.instrumentation.api.InstrumentationTags;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.Metadata;
import datadog.trace.core.MetadataConsumer;
import datadog.trace.core.http.OkHttpUtils;
import datadog.trace.core.serialization.GrowableBuffer;
import datadog.trace.core.serialization.Mapper;
import datadog.trace.core.serialization.Util;
import datadog.trace.core.serialization.Writable;
import datadog.trace.core.serialization.WritableFormatter;
import datadog.trace.core.serialization.msgpack.MsgPackWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.RequestBody;

public final class TraceMapperV0_5
implements TraceMapper {
    static final byte[] EMPTY = ByteBuffer.allocate(3).put((byte)-110).put((byte)-112).put((byte)-112).array();
    private final WritableFormatter dictionaryWriter;
    private final DictionaryMapper dictionaryMapper = new DictionaryMapper();
    private final Map<Object, Integer> encoding = new HashMap<Object, Integer>();
    private final GrowableBuffer dictionary;
    private final MetaWriter metaWriter = new MetaWriter();

    public TraceMapperV0_5() {
        this(0x200000);
    }

    public TraceMapperV0_5(int bufferSize) {
        this.dictionary = new GrowableBuffer(bufferSize);
        this.dictionaryWriter = new MsgPackWriter(this.dictionary);
        this.reset();
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        writable.startArray(trace.size());
        for (CoreSpan<?> span : trace) {
            writable.startArray(12);
            this.writeDictionaryEncoded(writable, span.getServiceName());
            this.writeDictionaryEncoded(writable, span.getOperationName());
            this.writeDictionaryEncoded(writable, span.getResourceName());
            writable.writeLong(span.getTraceId().toLong());
            writable.writeLong(span.getSpanId().toLong());
            writable.writeLong(span.getParentId().toLong());
            writable.writeLong(span.getStartTime());
            writable.writeLong(span.getDurationNano());
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable));
            this.writeMetrics(span, writable);
            this.writeDictionaryEncoded(writable, span.getType());
        }
    }

    private void writeMetrics(CoreSpan<?> span, Writable writable) {
        Map<CharSequence, Number> metrics = span.getUnsafeMetrics();
        int elementCount = metrics.size();
        elementCount += span.hasSamplingPriority() ? 1 : 0;
        elementCount += span.isMeasured() ? 1 : 0;
        writable.startMap(elementCount += span.isTopLevel() ? 1 : 0);
        if (span.hasSamplingPriority()) {
            this.writeDictionaryEncoded(writable, SAMPLING_PRIORITY_KEY);
            writable.writeInt(span.samplingPriority());
        }
        if (span.isMeasured()) {
            this.writeDictionaryEncoded(writable, InstrumentationTags.DD_MEASURED);
            writable.writeInt(1);
        }
        if (span.isTopLevel()) {
            this.writeDictionaryEncoded(writable, InstrumentationTags.DD_TOP_LEVEL);
            writable.writeInt(1);
        }
        for (Map.Entry<CharSequence, Number> metric : metrics.entrySet()) {
            this.writeDictionaryEncoded(writable, metric.getKey());
            writable.writeObject(metric.getValue(), null);
        }
    }

    private void writeDictionaryEncoded(Writable writable, Object value) {
        Object target = null == value ? "" : value;
        Integer encoded = this.encoding.get(target);
        if (null == encoded) {
            this.dictionaryWriter.format(target, this.dictionaryMapper);
            int dictionaryCode = this.dictionary.messageCount() - 1;
            this.encoding.put(target, dictionaryCode);
            writable.writeInt(dictionaryCode);
        } else {
            writable.writeInt(encoded);
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_5(this.dictionary.slice(), this.dictionary.messageCount());
    }

    @Override
    public int messageBufferSize() {
        return 0x200000;
    }

    @Override
    public void reset() {
        this.dictionary.reset();
        this.encoding.clear();
    }

    @Override
    public String endpoint() {
        return "v0.5";
    }

    private final class MetaWriter
    extends MetadataConsumer {
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int i;
            int size = metadata.getTags().size() + 2;
            long overlaps = 0L;
            if (!metadata.getBaggage().isEmpty()) {
                i = 0;
                for (Map.Entry<String, String> entry : metadata.getBaggage().entrySet()) {
                    if (!metadata.getTags().containsKey(entry.getKey())) {
                        ++size;
                    } else {
                        overlaps |= 1L << i;
                    }
                    ++i;
                }
            }
            this.writable.startMap(size);
            i = 0;
            for (Map.Entry<String, String> entry : metadata.getBaggage().entrySet()) {
                if ((overlaps & 1L << i) == 0L) {
                    TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getKey());
                    TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getValue());
                }
                ++i;
            }
            TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, TraceMapper.THREAD_NAME);
            TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, metadata.getThreadName());
            TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, TraceMapper.THREAD_ID);
            TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, String.valueOf(metadata.getThreadId()));
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getKey());
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getValue());
            }
        }
    }

    private static class PayloadV0_5
    extends Payload {
        private final ByteBuffer dictionary;
        private final int stringCount;

        private PayloadV0_5(ByteBuffer dictionary, int stringCount) {
            this.dictionary = dictionary;
            this.stringCount = stringCount;
        }

        @Override
        int sizeInBytes() {
            return 1 + this.msgpackArrayHeaderSize(this.stringCount) + this.dictionary.remaining() + this.msgpackArrayHeaderSize(this.traceCount()) + this.body.remaining();
        }

        @Override
        void writeTo(WritableByteChannel channel) throws IOException {
            for (ByteBuffer buffer : this.toList()) {
                while (buffer.hasRemaining()) {
                    channel.write(buffer);
                }
            }
        }

        @Override
        RequestBody toRequest() {
            return OkHttpUtils.msgpackRequestBodyOf(this.toList());
        }

        private List<ByteBuffer> toList() {
            return Arrays.asList(ByteBuffer.allocate(1).put(0, (byte)-110), this.msgpackArrayHeader(this.stringCount), this.dictionary, this.msgpackArrayHeader(this.traceCount()), this.body);
        }
    }

    private static class DictionaryMapper
    implements Mapper<Object> {
        private final byte[] numberByteArray = Util.integerToStringBuffer();

        private DictionaryMapper() {
        }

        @Override
        public void map(Object data, Writable packer) {
            if (data instanceof UTF8BytesString) {
                packer.writeObject(data, null);
            } else if (data instanceof Long || data instanceof Integer) {
                Util.writeLongAsString(((Number)data).longValue(), packer, this.numberByteArray);
            } else {
                assert (null != data) : "enclosing mapper should not provide null values";
                packer.writeString(String.valueOf(data), null);
            }
        }
    }
}

