/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization;

import datadog.trace.core.serialization.StreamingBuffer;
import java.nio.ByteBuffer;

public final class GrowableBuffer
implements StreamingBuffer {
    private ByteBuffer buffer;
    private int messageCount;

    public GrowableBuffer(int initialCapacity) {
        this.buffer = ByteBuffer.allocate(initialCapacity);
    }

    public ByteBuffer slice() {
        this.buffer.flip();
        return this.buffer.slice();
    }

    public int messageCount() {
        return this.messageCount;
    }

    public void reset() {
        this.messageCount = 0;
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
    }

    @Override
    public boolean isDirty() {
        return this.messageCount > 0;
    }

    @Override
    public void mark() {
        ++this.messageCount;
    }

    @Override
    public boolean flush() {
        return false;
    }

    @Override
    public void put(byte b) {
        this.checkCapacity(1);
        this.buffer.put(b);
    }

    @Override
    public void putShort(short s) {
        this.checkCapacity(2);
        this.buffer.putShort(s);
    }

    @Override
    public void putChar(char c) {
        this.checkCapacity(2);
        this.buffer.putChar(c);
    }

    @Override
    public void putInt(int i) {
        this.checkCapacity(4);
        this.buffer.putInt(i);
    }

    @Override
    public void putLong(long l) {
        this.checkCapacity(8);
        this.buffer.putLong(l);
    }

    @Override
    public void putFloat(float f) {
        this.checkCapacity(4);
        this.buffer.putFloat(f);
    }

    @Override
    public void putDouble(double d) {
        this.checkCapacity(8);
        this.buffer.putDouble(d);
    }

    @Override
    public void put(byte[] bytes) {
        this.checkCapacity(bytes.length);
        this.buffer.put(bytes);
    }

    @Override
    public void put(byte[] bytes, int offset, int length) {
        this.checkCapacity(length);
        this.buffer.put(bytes, offset, length);
    }

    @Override
    public void put(ByteBuffer buffer) {
        this.checkCapacity(buffer.remaining());
        this.buffer.put(buffer);
    }

    private void checkCapacity(int required) {
        if (this.buffer.remaining() < required) {
            this.resize();
        }
    }

    private void resize() {
        ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() * 2);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }
}

