/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.normalize;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLNormalizer {
    private static final Logger log;
    private static final long[] OBFUSCATE_SEQUENCES_STARTING_WITH;
    private static final long[] NON_WHITESPACE_SPLITTERS;
    private static final long SPACES;
    private static final long TABS;
    private static final long NEW_LINES;
    private static final long COMMAS;
    private static final long L_PAREN;
    private static final long R_PAREN;

    public static UTF8BytesString normalize(String sql) {
        byte[] utf8;
        block13: {
            utf8 = sql.getBytes(StandardCharsets.UTF_8);
            try {
                BitSet splitters = SQLNormalizer.findSplitterPositions(utf8);
                if (null == splitters) break block13;
                boolean modified = false;
                int outputLength = utf8.length;
                int end = outputLength - 1;
                int start = splitters.previousSetBit(end - 1);
                while (end > 0) {
                    if (start + 1 == end && utf8[end] != 39) {
                        if (utf8[end] >= 48 && utf8[end] <= 57) {
                            utf8[end] = 63;
                            modified = true;
                        }
                    } else {
                        int sequenceStart = start + 1;
                        boolean removeSequence = false;
                        if (utf8[end] == 39 || utf8[end] == 41 && utf8[end - 1] == 39) {
                            while (sequenceStart > 0) {
                                if (sequenceStart < end && (utf8[sequenceStart] == 39 || sequenceStart < end - 1 && utf8[sequenceStart] != 92 && utf8[sequenceStart + 1] == 39)) {
                                    removeSequence = true;
                                    break;
                                }
                                start = splitters.previousSetBit(start - 1);
                                sequenceStart = start + 1;
                            }
                        } else if (sequenceStart < end && (utf8[end] == 41 || SQLNormalizer.shouldReplaceSequenceStartingWith(utf8[sequenceStart]))) {
                            removeSequence = true;
                        }
                        if (removeSequence) {
                            int last = SQLNormalizer.isNonWhitespaceSplitter(utf8[end]) ? end - 1 : end;
                            System.arraycopy(utf8, last, utf8, sequenceStart, outputLength - last);
                            utf8[sequenceStart] = 63;
                            outputLength -= last - sequenceStart;
                            modified = true;
                        }
                    }
                    start = (end = start - 1) > 0 ? splitters.previousSetBit(end) : -1;
                }
                if (modified) {
                    return UTF8BytesString.create(Arrays.copyOf(utf8, outputLength));
                }
            }
            catch (Throwable paranoid) {
                log.debug("Error normalizing sql {}", (Object)sql, (Object)paranoid);
            }
        }
        return UTF8BytesString.create(sql, utf8);
    }

    private static BitSet findSplitterPositions(byte[] utf8) {
        int tokensFound;
        BitSet positions;
        block5: {
            int pos;
            block4: {
                long tokens;
                long word;
                int capacity = utf8.length + 7 & 0xFFFFFFF8;
                positions = new BitSet(capacity);
                tokensFound = 0;
                ByteBuffer buffer = ByteBuffer.wrap(utf8);
                for (pos = 0; pos < (utf8.length & 0xFFFFFFF8); pos += 8) {
                    word = buffer.getLong(pos);
                    tokensFound += Long.bitCount(tokens);
                    for (tokens = SQLNormalizer.findSplitters(word); tokens != 0L; tokens &= tokens - 1L) {
                        positions.set(pos + 7 - (Long.numberOfTrailingZeros(tokens) >>> 3));
                    }
                }
                if (pos >= utf8.length || utf8.length < 8) break block4;
                word = buffer.getLong(utf8.length - 8);
                tokensFound += Long.bitCount(tokens);
                for (tokens = SQLNormalizer.findSplitters(word <<= 8 - (utf8.length - pos) << 3); tokens != 0L; tokens &= tokens - 1L) {
                    positions.set(pos + 7 - (Long.numberOfTrailingZeros(tokens) >>> 3));
                }
                break block5;
            }
            if (pos >= utf8.length) break block5;
            for (int i = pos; i < utf8.length; ++i) {
                if (!Character.isWhitespace((char)(utf8[i] & 0xFF)) && !SQLNormalizer.isNonWhitespaceSplitter(utf8[i])) continue;
                positions.set(i);
            }
        }
        return tokensFound == 0 ? null : positions;
    }

    private static boolean shouldReplaceSequenceStartingWith(byte symbol) {
        return (OBFUSCATE_SEQUENCES_STARTING_WITH[(symbol & 0xFF) >>> 6] & 1L << (symbol & 0xFF)) != 0L;
    }

    private static boolean isNonWhitespaceSplitter(byte symbol) {
        return (NON_WHITESPACE_SPLITTERS[(symbol & 0xFF) >>> 6] & 1L << (symbol & 0xFF)) != 0L;
    }

    private static long findSplitters(long word) {
        return SQLNormalizer.tag(word, SPACES) | SQLNormalizer.tag(word, TABS) | SQLNormalizer.tag(word, NEW_LINES) | SQLNormalizer.tag(word, L_PAREN) | SQLNormalizer.tag(word, R_PAREN) | SQLNormalizer.tag(word, COMMAS);
    }

    private static long tag(long pattern, long word) {
        long holes = ((word ^= pattern) & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL;
        return (holes | word | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static long pattern(byte symbol) {
        return ((long)symbol & 0xFFL) * 0x101010101010101L;
    }

    static {
        int unsigned;
        log = LoggerFactory.getLogger(SQLNormalizer.class);
        OBFUSCATE_SEQUENCES_STARTING_WITH = new long[4];
        NON_WHITESPACE_SPLITTERS = new long[4];
        for (byte symbol : new byte[]{39, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 43, 46}) {
            unsigned = symbol & 0xFF;
            int n = unsigned >>> 6;
            OBFUSCATE_SEQUENCES_STARTING_WITH[n] = OBFUSCATE_SEQUENCES_STARTING_WITH[n] | 1L << unsigned;
        }
        for (byte symbol : new byte[]{44, 40, 41}) {
            unsigned = symbol & 0xFF;
            int n = unsigned >>> 6;
            NON_WHITESPACE_SPLITTERS[n] = NON_WHITESPACE_SPLITTERS[n] | 1L << unsigned;
        }
        SPACES = SQLNormalizer.pattern((byte)32);
        TABS = SQLNormalizer.pattern((byte)9);
        NEW_LINES = SQLNormalizer.pattern((byte)10);
        COMMAS = SQLNormalizer.pattern((byte)44);
        L_PAREN = SQLNormalizer.pattern((byte)40);
        R_PAREN = SQLNormalizer.pattern((byte)41);
    }
}

