/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization.msgpack;

import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.core.serialization.Codec;
import datadog.trace.core.serialization.EncodingCache;
import datadog.trace.core.serialization.Mapper;
import datadog.trace.core.serialization.StreamingBuffer;
import datadog.trace.core.serialization.ValueWriter;
import datadog.trace.core.serialization.WritableFormatter;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class MsgPackWriter
implements WritableFormatter {
    public static final byte NULL = -64;
    public static final byte FALSE = -62;
    public static final byte TRUE = -61;
    public static final byte UINT8 = -52;
    public static final byte UINT16 = -51;
    public static final byte UINT32 = -50;
    public static final byte UINT64 = -49;
    public static final byte INT8 = -48;
    public static final byte INT16 = -47;
    public static final byte INT32 = -46;
    public static final byte INT64 = -45;
    public static final byte FLOAT32 = -54;
    public static final byte FLOAT64 = -53;
    public static final byte STR8 = -39;
    public static final byte STR16 = -38;
    public static final byte STR32 = -37;
    public static final byte BIN8 = -60;
    public static final byte BIN16 = -59;
    public static final byte BIN32 = -58;
    public static final byte ARRAY16 = -36;
    public static final byte ARRAY32 = -35;
    public static final byte MAP16 = -34;
    public static final byte MAP32 = -33;
    public static final int NEGFIXNUM = 224;
    public static final int FIXSTR = 160;
    public static final int FIXARRAY = 144;
    public static final int FIXMAP = 128;
    private final Codec codec;
    private final StreamingBuffer buffer;

    public MsgPackWriter(StreamingBuffer buffer) {
        this(Codec.INSTANCE, buffer);
    }

    public MsgPackWriter(Codec codec, StreamingBuffer buffer) {
        this.codec = codec;
        this.buffer = buffer;
    }

    @Override
    public void flush() {
        if (this.buffer.isDirty()) {
            this.buffer.flush();
        }
    }

    @Override
    public <T> boolean format(T message, Mapper<T> mapper) {
        try {
            mapper.map(message, this);
            this.buffer.mark();
            return true;
        }
        catch (BufferOverflowException overflow) {
            if (this.buffer.flush()) {
                try {
                    mapper.map(message, this);
                    this.buffer.mark();
                    return true;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    // empty catch block
                }
            }
            this.buffer.reset();
            return false;
        }
    }

    public void writeMap(Map<? extends CharSequence, ? extends Object> map, EncodingCache encodingCache) {
        this.startMap(map.size());
        for (Map.Entry<? extends CharSequence, ? extends Object> entry : map.entrySet()) {
            this.writeString(entry.getKey(), encodingCache);
            this.writeObject(entry.getValue(), encodingCache);
        }
    }

    @Override
    public void writeObject(Object value, EncodingCache encodingCache) {
        if (value instanceof UTF8BytesString) {
            this.writeUTF8((UTF8BytesString)value);
        } else if (null == value) {
            this.writeNull();
        } else {
            ValueWriter writer = (ValueWriter)this.codec.get(value.getClass());
            writer.write(value, this, encodingCache);
        }
    }

    @Override
    public void writeNull() {
        this.buffer.put((byte)-64);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.buffer.put(value ? (byte)-61 : -62);
    }

    @Override
    public void writeString(CharSequence s, EncodingCache encodingCache) {
        if (null == s) {
            this.writeNull();
        } else {
            byte[] utf8;
            if (null != encodingCache && null != (utf8 = encodingCache.encode(s))) {
                this.writeUTF8(utf8);
                return;
            }
            if (s instanceof UTF8BytesString) {
                this.writeUTF8((UTF8BytesString)s);
            } else {
                this.writeUTF8(String.valueOf(s).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    @Override
    public void writeUTF8(byte[] string, int offset, int length) {
        this.writeStringHeader(length);
        this.buffer.put(string, offset, length);
    }

    @Override
    public void writeUTF8(byte[] string) {
        this.writeUTF8(string, 0, string.length);
    }

    @Override
    public void writeUTF8(UTF8BytesString string) {
        this.writeStringHeader(string.encodedLength());
        this.buffer.put(string.getUtf8Bytes());
    }

    @Override
    public void writeBinary(byte[] binary) {
        this.writeBinaryHeader(binary.length);
        this.buffer.put(binary);
    }

    @Override
    public void writeBinary(byte[] binary, int offset, int length) {
        this.writeBinaryHeader(length);
        this.buffer.put(binary, offset, length);
    }

    @Override
    public void writeBinary(ByteBuffer binary) {
        ByteBuffer slice = binary.slice();
        this.writeBinaryHeader(slice.limit() - slice.position());
        this.buffer.put(slice);
    }

    @Override
    public void writeInt(int value) {
        if (value < 0) {
            switch (Integer.numberOfLeadingZeros(~value)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.buffer.put((byte)-46);
                    this.buffer.putInt(value);
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.buffer.put((byte)-47);
                    this.buffer.putChar((char)value);
                    break;
                }
                case 25: 
                case 26: {
                    this.buffer.put((byte)-48);
                    this.buffer.put((byte)value);
                    break;
                }
                default: {
                    this.buffer.put((byte)(0xE0 | value));
                    break;
                }
            }
        } else {
            switch (Integer.numberOfLeadingZeros(value)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.buffer.put((byte)-50);
                    this.buffer.putInt(value);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    this.buffer.put((byte)-51);
                    this.buffer.putChar((char)value);
                    break;
                }
                case 24: {
                    this.buffer.put((byte)-52);
                    this.buffer.put((byte)value);
                    break;
                }
                default: {
                    this.buffer.put((byte)value);
                }
            }
        }
    }

    @Override
    public void writeSignedInt(int value) {
        this.writeInt(value);
    }

    @Override
    public void writeLong(long value) {
        if (value < 0L) {
            switch (Long.numberOfLeadingZeros(value ^ 0xFFFFFFFFFFFFFFFFL)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    this.buffer.put((byte)-45);
                    this.buffer.putLong(value);
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    this.buffer.put((byte)-46);
                    this.buffer.putInt((int)value);
                    break;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: {
                    this.buffer.put((byte)-47);
                    this.buffer.putChar((char)value);
                    break;
                }
                case 57: 
                case 58: {
                    this.buffer.put((byte)-48);
                    this.buffer.put((byte)value);
                    break;
                }
                default: {
                    this.buffer.put((byte)(0xE0L | value));
                    break;
                }
            }
        } else {
            switch (Long.numberOfLeadingZeros(value)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this.buffer.put((byte)-49);
                    this.buffer.putLong(value);
                    break;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    this.buffer.put((byte)-50);
                    this.buffer.putInt((int)value);
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    this.buffer.put((byte)-51);
                    this.buffer.putChar((char)value);
                    break;
                }
                case 56: {
                    this.buffer.put((byte)-52);
                    this.buffer.put((byte)value);
                    break;
                }
                default: {
                    this.buffer.put((byte)value);
                }
            }
        }
    }

    @Override
    public void writeSignedLong(long value) {
        this.writeLong(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buffer.put((byte)-54);
        this.buffer.putFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.buffer.put((byte)-53);
        this.buffer.putDouble(value);
    }

    @Override
    public void startMap(int elementCount) {
        if (elementCount < 16) {
            this.buffer.put((byte)(0x80 | elementCount));
        } else if (elementCount < 65536) {
            this.buffer.put((byte)-34);
            this.buffer.putShort((short)elementCount);
        } else {
            this.buffer.put((byte)-33);
            this.buffer.putInt(elementCount);
        }
    }

    @Override
    public void startStruct(int elementCount) {
        this.startArray(elementCount);
    }

    @Override
    public void startArray(int elementCount) {
        if (elementCount < 16) {
            this.buffer.put((byte)(0x90 | elementCount));
        } else if (elementCount < 65536) {
            this.buffer.put((byte)-36);
            this.buffer.putShort((short)elementCount);
        } else {
            this.buffer.put((byte)-35);
            this.buffer.putInt(elementCount);
        }
    }

    void writeStringHeader(int length) {
        if (length < 16) {
            this.buffer.put((byte)(0xA0 | length));
        } else if (length < 256) {
            this.buffer.put((byte)-39);
            this.buffer.put((byte)length);
        } else if (length < 65536) {
            this.buffer.put((byte)-38);
            this.buffer.putShort((short)length);
        } else {
            this.buffer.put((byte)-37);
            this.buffer.putInt(length);
        }
    }

    void writeBinaryHeader(int length) {
        if (length < 256) {
            this.buffer.put((byte)-60);
            this.buffer.put((byte)length);
        } else if (length < 65536) {
            this.buffer.put((byte)-59);
            this.buffer.putShort((short)length);
        } else {
            this.buffer.put((byte)-58);
            this.buffer.putInt(length);
        }
    }
}

