/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider;

import datadog.trace.bootstrap.config.provider.ConfigProvider;
import datadog.trace.bootstrap.config.provider.SystemPropertiesConfigSource;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

final class EnvironmentConfigSource
extends ConfigProvider.Source {
    private static final Pattern ENV_REPLACEMENT = Pattern.compile("[^a-zA-Z0-9_]");

    EnvironmentConfigSource() {
    }

    @Override
    protected String get(String key) {
        return System.getenv(EnvironmentConfigSource.propertyNameToEnvironmentVariableName(key));
    }

    @Nonnull
    private static String propertyNameToEnvironmentVariableName(String setting) {
        return ENV_REPLACEMENT.matcher(SystemPropertiesConfigSource.propertyNameToSystemPropertyName(setting).toUpperCase()).replaceAll("_");
    }
}

