/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfo;

class CircleCIInfo
extends CIProviderInfo {
    public static final String CIRCLECI = "CIRCLECI";
    public static final String CIRCLECI_PROVIDER_NAME = "circleci";
    public static final String CIRCLECI_PIPELINE_ID = "CIRCLE_WORKFLOW_ID";
    public static final String CIRCLECI_PIPELINE_NAME = "CIRCLE_PROJECT_REPONAME";
    public static final String CIRCLECI_PIPELINE_NUMBER = "CIRCLE_BUILD_NUM";
    public static final String CIRCLECI_BUILD_URL = "CIRCLE_BUILD_URL";
    public static final String CIRCLECI_WORKSPACE_PATH = "CIRCLE_WORKING_DIRECTORY";
    public static final String CIRCLECI_GIT_REPOSITORY_URL = "CIRCLE_REPOSITORY_URL";
    public static final String CIRCLECI_GIT_COMMIT = "CIRCLE_SHA1";
    public static final String CIRCLECI_GIT_BRANCH = "CIRCLE_BRANCH";
    public static final String CIRCLECI_GIT_TAG = "CIRCLE_TAG";

    CircleCIInfo() {
    }

    @Override
    protected GitInfo buildCIGitInfo() {
        String gitTag = this.normalizeRef(System.getenv(CIRCLECI_GIT_TAG));
        return new GitInfo(this.filterSensitiveInfo(System.getenv(CIRCLECI_GIT_REPOSITORY_URL)), this.buildGitBranch(gitTag), gitTag, new CommitInfo(System.getenv(CIRCLECI_GIT_COMMIT)));
    }

    @Override
    protected CIProviderInfo.CIInfo buildCIInfo() {
        return CIProviderInfo.CIInfo.builder().ciProviderName(CIRCLECI_PROVIDER_NAME).ciPipelineId(System.getenv(CIRCLECI_PIPELINE_ID)).ciPipelineName(System.getenv(CIRCLECI_PIPELINE_NAME)).ciPipelineNumber(System.getenv(CIRCLECI_PIPELINE_NUMBER)).ciPipelineUrl(System.getenv(CIRCLECI_BUILD_URL)).ciJobUrl(System.getenv(CIRCLECI_BUILD_URL)).ciWorkspace(this.expandTilde(System.getenv(CIRCLECI_WORKSPACE_PATH))).build();
    }

    private String buildGitBranch(String gitTag) {
        if (gitTag != null) {
            return null;
        }
        return this.normalizeRef(System.getenv(CIRCLECI_GIT_BRANCH));
    }
}

