/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.api.IOLogger;
import datadog.trace.common.writer.ddagent.DDAgentFeaturesDiscovery;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.core.monitor.Counter;
import datadog.trace.core.monitor.Monitoring;
import datadog.trace.core.monitor.Recording;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentApi {
    private static final Logger log = LoggerFactory.getLogger(DDAgentApi.class);
    private static final String DATADOG_CLIENT_COMPUTED_STATS = "Datadog-Client-Computed-Stats";
    private static final String DATADOG_CLIENT_COMPUTED_TOP_LEVEL = "Datadog-Client-Computed-Top-Level";
    private static final String X_DATADOG_TRACE_COUNT = "X-Datadog-Trace-Count";
    private static final String DATADOG_DROPPED_TRACE_COUNT = "Datadog-Client-Dropped-P0-Traces";
    private static final String DATADOG_DROPPED_SPAN_COUNT = "Datadog-Client-Dropped-P0-Spans";
    private static final String DATADOG_AGENT_STATE = "Datadog-Agent-State";
    private final List<DDAgentResponseListener> responseListeners = new ArrayList<DDAgentResponseListener>();
    private long totalTraces = 0L;
    private long receivedTraces = 0L;
    private long sentTraces = 0L;
    private long failedTraces = 0L;
    private final Recording sendPayloadTimer;
    private final Counter agentErrorCounter;
    private static final JsonAdapter<Map<String, Map<String, Number>>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Double.class})}));
    private final DDAgentFeaturesDiscovery featuresDiscovery;
    private final OkHttpClient httpClient;
    private final HttpUrl agentUrl;
    private final boolean metricsEnabled;
    private final IOLogger ioLogger = new IOLogger(log);

    public DDAgentApi(OkHttpClient client, HttpUrl agentUrl, DDAgentFeaturesDiscovery featuresDiscovery, Monitoring monitoring, boolean metricsEnabled) {
        this.featuresDiscovery = featuresDiscovery;
        this.agentUrl = agentUrl;
        this.httpClient = client;
        this.sendPayloadTimer = monitoring.newTimer("trace.agent.send.time");
        this.agentErrorCounter = monitoring.newCounter("trace.agent.error.counter");
        this.metricsEnabled = metricsEnabled;
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    /*
     * Exception decompiling
     */
    Response sendSerializedTraces(Payload payload) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleAgentChange(String state) {
        String previous = this.featuresDiscovery.state();
        if (!Objects.equals(state, previous)) {
            this.featuresDiscovery.discover();
        }
    }

    private void countAndLogSuccessfulSend(int traceCount, int sizeInBytes) {
        this.sentTraces += (long)traceCount;
        this.ioLogger.success(this.createSendLogMessage(traceCount, sizeInBytes, "Success"), new Object[0]);
    }

    private void countAndLogFailedSend(int traceCount, int sizeInBytes, okhttp3.Response response, IOException outer) {
        this.failedTraces += (long)traceCount;
        String agentError = DDAgentApi.getResponseBody(response);
        String sendErrorString = this.createSendLogMessage(traceCount, sizeInBytes, agentError.isEmpty() ? "Error" : agentError);
        this.ioLogger.error(sendErrorString, DDAgentApi.toLoggerResponse(response, agentError), outer);
    }

    private static IOLogger.Response toLoggerResponse(okhttp3.Response response, String body) {
        if (response == null) {
            return null;
        }
        return new IOLogger.Response(response.code(), response.message(), body);
    }

    private static String getResponseBody(okhttp3.Response response) {
        if (response != null) {
            try {
                return response.body().string().trim();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
        return "";
    }

    private String createSendLogMessage(int traceCount, int sizeInBytes, String prefix) {
        String sizeString = sizeInBytes > 1024 ? sizeInBytes / 1024 + "KB" : sizeInBytes + "B";
        return prefix + " while sending " + traceCount + " (size=" + sizeString + ") traces to the DD agent. Total: " + this.totalTraces + ", Received: " + this.receivedTraces + ", Sent: " + this.sentTraces + ", Failed: " + this.failedTraces + ".";
    }

    public static final class Response {
        private final boolean success;
        private final Integer status;
        private final Throwable exception;
        private final String response;

        public static Response success(int status) {
            return new Response(true, status, null, null);
        }

        public static Response success(int status, String response) {
            return new Response(true, status, null, response);
        }

        public static Response success(int status, Throwable exception) {
            return new Response(true, status, exception, null);
        }

        public static Response failed(int status) {
            return new Response(false, status, null, null);
        }

        public static Response failed(Throwable exception) {
            return new Response(false, null, exception, null);
        }

        private Response(boolean success, Integer status, Throwable exception, String response) {
            this.success = success;
            this.status = status;
            this.exception = exception;
            this.response = response;
        }

        public final boolean success() {
            return this.success;
        }

        public final Integer status() {
            return this.status;
        }

        public final Throwable exception() {
            return this.exception;
        }

        public final String response() {
            return this.response;
        }
    }
}

