/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.api.IntFunction;
import datadog.trace.api.cache.RadixTreeCache;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.core.DDSpan;
import datadog.trace.util.AgentTaskScheduler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jctools.counters.CountersFactory;
import org.jctools.counters.FixedSizeStripedLongCounter;

public class HealthMetrics
implements AutoCloseable {
    private static final IntFunction<String[]> STATUS_TAGS = new IntFunction<String[]>(){

        @Override
        public String[] apply(int httpStatus) {
            return new String[]{"status:" + httpStatus};
        }
    };
    private static final String[] NO_TAGS = new String[0];
    private final RadixTreeCache<String[]> statusTagsCache = new RadixTreeCache<String[]>(16, 32, STATUS_TAGS, 200, 400);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile AgentTaskScheduler.Scheduled<HealthMetrics> cancellation;
    private final FixedSizeStripedLongCounter userDropEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter userKeepEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter samplerDropEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter samplerKeepEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter unsetPriorityEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter userDropDroppedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter userKeepDroppedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter samplerDropDroppedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter samplerKeepDroppedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter unsetPriorityDroppedTraces = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter enqueuedSpans = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final StatsDClient statsd;
    private final long interval;
    private final TimeUnit units;

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.cancellation = AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(new Flush(), this, this.interval, this.interval, this.units);
        }
    }

    public HealthMetrics(StatsDClient statsd) {
        this(statsd, 30L, TimeUnit.SECONDS);
    }

    public HealthMetrics(StatsDClient statsd, long interval, TimeUnit units) {
        this.statsd = statsd;
        this.interval = interval;
        this.units = units;
    }

    public void onStart(int queueCapacity) {
        this.statsd.recordGaugeValue("queue.max_length", (long)queueCapacity, NO_TAGS);
    }

    public void onShutdown(boolean flushSuccess) {
    }

    public void onPublish(List<DDSpan> trace, int samplingPriority) {
        switch (samplingPriority) {
            case -1: {
                this.userDropEnqueuedTraces.inc();
                break;
            }
            case 2: {
                this.userKeepEnqueuedTraces.inc();
                break;
            }
            case 0: {
                this.samplerDropEnqueuedTraces.inc();
                break;
            }
            case 1: {
                this.samplerKeepEnqueuedTraces.inc();
                break;
            }
            default: {
                this.unsetPriorityEnqueuedTraces.inc();
            }
        }
        this.enqueuedSpans.inc((long)trace.size());
    }

    public void onFailedPublish(int samplingPriority) {
        switch (samplingPriority) {
            case -1: {
                this.userDropDroppedTraces.inc();
                break;
            }
            case 2: {
                this.userKeepDroppedTraces.inc();
                break;
            }
            case 0: {
                this.samplerDropDroppedTraces.inc();
                break;
            }
            case 1: {
                this.samplerKeepDroppedTraces.inc();
                break;
            }
            default: {
                this.unsetPriorityDroppedTraces.inc();
            }
        }
    }

    public void onScheduleFlush(boolean previousIncomplete) {
    }

    public void onFlush(boolean early) {
    }

    public void onSerialize(int serializedSizeInBytes) {
        this.statsd.count("queue.enqueued.bytes", (long)serializedSizeInBytes, NO_TAGS);
    }

    public void onFailedSerialize(List<DDSpan> trace, Throwable optionalCause) {
    }

    public void onSend(int traceCount, int sizeInBytes, DDAgentApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    public void onFailedSend(int traceCount, int sizeInBytes, DDAgentApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    private void onSendAttempt(int traceCount, int sizeInBytes, DDAgentApi.Response response) {
        this.statsd.incrementCounter("api.requests.total", NO_TAGS);
        this.statsd.count("flush.traces.total", (long)traceCount, NO_TAGS);
        this.statsd.count("flush.bytes.total", (long)sizeInBytes, NO_TAGS);
        if (response.exception() != null) {
            this.statsd.incrementCounter("api.errors.total", NO_TAGS);
        }
        if (response.status() != null) {
            this.statsd.incrementCounter("api.responses.total", this.statusTagsCache.get(response.status()));
        }
    }

    @Override
    public void close() {
        if (null != this.cancellation) {
            this.cancellation.cancel();
        }
    }

    private static class Flush
    implements AgentTaskScheduler.Task<HealthMetrics> {
        private static final String[] USER_DROP_TAG = new String[]{"priority:user_drop"};
        private static final String[] USER_KEEP_TAG = new String[]{"priority:user_keep"};
        private static final String[] SAMPLER_DROP_TAG = new String[]{"priority:sampler_drop"};
        private static final String[] SAMPLER_KEEP_TAG = new String[]{"priority:sampler_keep"};
        private static final String[] UNSET_TAG = new String[]{"priority:unset"};

        private Flush() {
        }

        @Override
        public void run(HealthMetrics target) {
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.userDropEnqueuedTraces, USER_DROP_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.userKeepEnqueuedTraces, USER_KEEP_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.samplerDropEnqueuedTraces, SAMPLER_DROP_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.samplerKeepEnqueuedTraces, SAMPLER_KEEP_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.unsetPriorityEnqueuedTraces, UNSET_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.userDropDroppedTraces, USER_DROP_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.userKeepDroppedTraces, USER_KEEP_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.samplerDropDroppedTraces, SAMPLER_DROP_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.samplerKeepDroppedTraces, SAMPLER_KEEP_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.unsetPriorityDroppedTraces, UNSET_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.spans", target.enqueuedSpans, NO_TAGS);
        }

        private void reportIfChanged(StatsDClient statsDClient, String aspect, FixedSizeStripedLongCounter counter, String[] tags) {
            long count = counter.getAndReset();
            if (count > 0L) {
                statsDClient.count(aspect, count, tags);
            }
        }
    }
}

