/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci.git;

import java.net.URI;
import java.net.URISyntaxException;

public class GitUtils {
    public static String normalizeRef(String rawRef) {
        if (rawRef == null || rawRef.isEmpty()) {
            return null;
        }
        String ref = rawRef;
        if (ref.startsWith("origin")) {
            ref = ref.replace("origin/", "");
        } else if (ref.startsWith("refs/heads")) {
            ref = ref.replace("refs/heads/", "");
        }
        if (ref.startsWith("refs/tags")) {
            return ref.replace("refs/tags/", "");
        }
        if (ref.startsWith("tags")) {
            return ref.replace("tags/", "");
        }
        return ref;
    }

    public static String filterSensitiveInfo(String urlStr) {
        if (urlStr == null || urlStr.isEmpty()) {
            return null;
        }
        try {
            URI url = new URI(urlStr);
            String userInfo = url.getRawUserInfo();
            return urlStr.replace(userInfo + "@", "");
        }
        catch (URISyntaxException ex) {
            return urlStr;
        }
    }
}

