/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.api.DDId;
import datadog.trace.core.DDSpan;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

class DDSpanJsonAdapter
extends JsonAdapter<DDSpan> {
    private final boolean hexIds;

    DDSpanJsonAdapter(boolean hexIds) {
        this.hexIds = hexIds;
    }

    public static JsonAdapter.Factory buildFactory(final boolean hexIds) {
        return new JsonAdapter.Factory(){

            public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
                Class rawType = Types.getRawType((Type)type);
                if (rawType.isAssignableFrom(DDSpan.class)) {
                    return new DDSpanJsonAdapter(hexIds);
                }
                return null;
            }
        };
    }

    public DDSpan fromJson(JsonReader reader) {
        throw new UnsupportedOperationException();
    }

    public void toJson(JsonWriter writer, DDSpan span) throws IOException {
        writer.beginObject();
        writer.name("service");
        writer.value(span.getServiceName());
        writer.name("name");
        writer.value(span.getOperationName().toString());
        writer.name("resource");
        writer.value(span.getResourceName().toString());
        writer.name("trace_id");
        this.writeId(writer, span.getTraceId());
        writer.name("span_id");
        this.writeId(writer, span.getSpanId());
        writer.name("parent_id");
        this.writeId(writer, span.getParentId());
        writer.name("start");
        writer.value(span.getStartTime());
        writer.name("duration");
        writer.value(span.getDurationNano());
        writer.name("type");
        writer.value(span.getSpanType());
        writer.name("error");
        writer.value((long)span.getError());
        writer.name("metrics");
        writer.beginObject();
        for (Map.Entry<CharSequence, Number> entry : span.getUnsafeMetrics().entrySet()) {
            writer.name(entry.getKey().toString());
            writer.value(entry.getValue());
        }
        writer.endObject();
        writer.name("meta");
        writer.beginObject();
        Map<String, Object> tags = span.getTags();
        for (Map.Entry<String, String> entry : span.context().getBaggageItems().entrySet()) {
            if (tags.containsKey(entry.getKey())) continue;
            writer.name(entry.getKey());
            writer.value(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : tags.entrySet()) {
            writer.name(entry.getKey());
            writer.value(String.valueOf(entry.getValue()));
        }
        writer.endObject();
        writer.endObject();
    }

    private void writeId(JsonWriter writer, DDId id) throws IOException {
        if (this.hexIds) {
            writer.value(id.toHexString());
        } else {
            writer.value(id.toLong());
        }
    }
}

