/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.DDId;
import datadog.trace.api.Functions;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.propagation.TagContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContextInterpreter
implements AgentPropagation.KeyClassifier {
    protected final Map<String, String> taggedHeaders;
    protected DDId traceId;
    protected DDId spanId;
    protected int samplingPriority;
    protected Map<String, String> tags;
    protected Map<String, String> baggage;
    protected String origin;
    protected String forwardedFor;
    protected String forwardedPort;
    protected boolean valid;
    private static final DDCache<String, String> CACHE = DDCaches.newFixedSizeCache(64);

    protected String toLowerCase(String key) {
        return CACHE.computeIfAbsent(key, Functions.LowerCase.INSTANCE);
    }

    protected ContextInterpreter(Map<String, String> taggedHeaders) {
        this.taggedHeaders = taggedHeaders;
        this.reset();
    }

    protected final boolean handledForwarding(String key, String value) {
        if ("x-forwarded-for".equalsIgnoreCase(key)) {
            String firstValue = HttpCodec.firstHeaderValue(value);
            if (null != firstValue) {
                this.forwardedFor = firstValue;
            }
            return true;
        }
        if ("x-forwarded-port".equalsIgnoreCase(key)) {
            String firstValue = HttpCodec.firstHeaderValue(value);
            if (null != firstValue) {
                this.forwardedPort = firstValue;
            }
            return true;
        }
        return false;
    }

    public ContextInterpreter reset() {
        this.traceId = DDId.ZERO;
        this.spanId = DDId.ZERO;
        this.samplingPriority = this.defaultSamplingPriority();
        this.origin = null;
        this.forwardedFor = null;
        this.forwardedPort = null;
        this.tags = Collections.emptyMap();
        this.baggage = Collections.emptyMap();
        this.valid = true;
        return this;
    }

    TagContext build() {
        if (this.valid) {
            if (!DDId.ZERO.equals((Object)this.traceId)) {
                ExtractedContext context = new ExtractedContext(this.traceId, this.spanId, this.samplingPriority, this.origin, this.forwardedFor, this.forwardedPort, this.baggage, this.tags);
                context.lockSamplingPriority();
                return context;
            }
            if (this.origin != null || this.forwardedFor != null || this.forwardedPort != null || !this.tags.isEmpty()) {
                return new TagContext(this.origin, this.forwardedFor, this.forwardedPort, this.tags);
            }
        }
        return null;
    }

    protected void invalidateContext() {
        this.valid = false;
    }

    protected int defaultSamplingPriority() {
        return -128;
    }

    public static abstract class Factory {
        public ContextInterpreter create(Map<String, String> tagsMapping) {
            return this.construct(this.cleanMapping(tagsMapping));
        }

        protected abstract ContextInterpreter construct(Map<String, String> var1);

        protected Map<String, String> cleanMapping(Map<String, String> taggedHeaders) {
            HashMap<String, String> cleanedMapping = new HashMap<String, String>(taggedHeaders.size() * 4 / 3);
            for (Map.Entry<String, String> association : taggedHeaders.entrySet()) {
                cleanedMapping.put(association.getKey().trim().toLowerCase(), association.getValue().trim().toLowerCase());
            }
            return cleanedMapping;
        }
    }
}

