/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DDAgentFeaturesDiscovery;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.common.writer.ddagent.TraceMapperV0_4;
import datadog.trace.common.writer.ddagent.TraceMapperV0_5;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.monitor.HealthMetrics;
import datadog.trace.core.monitor.Monitoring;
import datadog.trace.core.monitor.Recording;
import datadog.trace.core.serialization.ByteBufferConsumer;
import datadog.trace.core.serialization.FlushingBuffer;
import datadog.trace.core.serialization.WritableFormatter;
import datadog.trace.core.serialization.msgpack.MsgPackWriter;
import java.nio.ByteBuffer;
import java.util.List;
import org.jctools.counters.CountersFactory;
import org.jctools.counters.FixedSizeStripedLongCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadDispatcher
implements ByteBufferConsumer {
    private static final Logger log = LoggerFactory.getLogger(PayloadDispatcher.class);
    private final DDAgentApi api;
    private final DDAgentFeaturesDiscovery featuresDiscovery;
    private final HealthMetrics healthMetrics;
    private final Monitoring monitoring;
    private Recording batchTimer;
    private TraceMapper traceMapper;
    private WritableFormatter packer;
    private final FixedSizeStripedLongCounter droppedSpanCount = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter droppedTraceCount = CountersFactory.createFixedSizeStripedCounter((int)8);

    public PayloadDispatcher(DDAgentFeaturesDiscovery featuresDiscovery, DDAgentApi api, HealthMetrics healthMetrics, Monitoring monitoring) {
        this.featuresDiscovery = featuresDiscovery;
        this.api = api;
        this.healthMetrics = healthMetrics;
        this.monitoring = monitoring;
    }

    void flush() {
        if (null != this.packer) {
            this.packer.flush();
        }
    }

    public void onDroppedTrace(int spanCount) {
        this.droppedSpanCount.inc((long)spanCount);
        this.droppedTraceCount.inc();
    }

    void addTrace(List<? extends CoreSpan<?>> trace) {
        this.selectTraceMapper();
        if (null == this.traceMapper || !this.packer.format(trace, this.traceMapper)) {
            this.healthMetrics.onFailedPublish(trace.get(0).samplingPriority());
        }
    }

    private void selectTraceMapper() {
        if (null == this.traceMapper) {
            this.featuresDiscovery.discover();
            String tracesUrl = this.featuresDiscovery.getTraceEndpoint();
            if ("v0.5/traces".equalsIgnoreCase(tracesUrl)) {
                this.traceMapper = new TraceMapperV0_5();
            } else if (null != tracesUrl) {
                this.traceMapper = new TraceMapperV0_4();
            }
            if (null != this.traceMapper && null == this.packer) {
                this.batchTimer = this.monitoring.newTimer("tracer.trace.buffer.fill.time", "endpoint:" + this.traceMapper.endpoint());
                this.packer = new MsgPackWriter(new FlushingBuffer(this.traceMapper.messageBufferSize(), this));
                this.batchTimer.start();
            }
        }
    }

    Payload newPayload(int messageCount, ByteBuffer buffer) {
        return this.traceMapper.newPayload().withBody(messageCount, buffer).withDroppedSpans(this.droppedSpanCount.getAndReset()).withDroppedTraces(this.droppedTraceCount.getAndReset());
    }

    @Override
    public void accept(int messageCount, ByteBuffer buffer) {
        if (messageCount > 0) {
            this.batchTimer.reset();
            Payload payload = this.newPayload(messageCount, buffer);
            int sizeInBytes = payload.sizeInBytes();
            this.healthMetrics.onSerialize(sizeInBytes);
            DDAgentApi.Response response = this.api.sendSerializedTraces(payload);
            this.traceMapper.reset();
            if (response.success()) {
                if (log.isDebugEnabled()) {
                    log.debug("Successfully sent {} traces to the API", (Object)messageCount);
                }
                this.healthMetrics.onSend(messageCount, sizeInBytes, response);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to send {} traces of size {} bytes to the API", (Object)messageCount, (Object)sizeInBytes);
                }
                this.healthMetrics.onFailedSend(messageCount, sizeInBytes, response);
            }
        }
    }
}

