/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import datadog.trace.api.Config;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class AgentProxySelector
extends ProxySelector {
    public static final ProxySelector INSTANCE = new AgentProxySelector();
    private static final List<Proxy> DIRECT = Collections.singletonList(Proxy.NO_PROXY);
    private final Set<String> noProxyHosts = Config.get().getNoProxyHosts();
    private final ProxySelector defaultProxySelector = ProxySelector.getDefault();

    @Override
    public List<Proxy> select(URI uri) {
        if (this.noProxyHosts.contains(uri.getHost())) {
            return DIRECT;
        }
        return this.defaultProxySelector.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.defaultProxySelector.connectFailed(uri, sa, ioe);
    }
}

