/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.trace.api.Config;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.StatsDClient;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DDAgentFeaturesDiscovery;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.PayloadDispatcher;
import datadog.trace.common.writer.ddagent.Prioritization;
import datadog.trace.common.writer.ddagent.TraceProcessingWorker;
import datadog.trace.core.DDSpan;
import datadog.trace.core.http.OkHttpUtils;
import datadog.trace.core.monitor.HealthMetrics;
import datadog.trace.core.monitor.Monitoring;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(DDAgentWriter.class);
    private static final int BUFFER_SIZE = 1024;
    private final DDAgentApi api;
    private final TraceProcessingWorker traceProcessingWorker;
    private final PayloadDispatcher dispatcher;
    private final DDAgentFeaturesDiscovery discovery;
    private volatile boolean closed;
    public final HealthMetrics healthMetrics;

    public static DDAgentWriterBuilder builder() {
        return new DDAgentWriterBuilder();
    }

    private DDAgentWriter(DDAgentApi agentApi, String agentHost, int traceAgentPort, String unixDomainSocket, long timeoutMillis, int traceBufferSize, HealthMetrics healthMetrics, int flushFrequencySeconds, Prioritization prioritization, Monitoring monitoring, boolean traceAgentV05Enabled, boolean metricsReportingEnabled, DDAgentFeaturesDiscovery featureDiscovery) {
        OkHttpClient client;
        HttpUrl agentUrl = HttpUrl.get((String)("http://" + agentHost + ":" + traceAgentPort));
        OkHttpClient okHttpClient = client = null == featureDiscovery || null == agentApi ? OkHttpUtils.buildHttpClient(agentUrl, unixDomainSocket, timeoutMillis) : null;
        if (null == featureDiscovery) {
            featureDiscovery = new DDAgentFeaturesDiscovery(client, monitoring, agentUrl, traceAgentV05Enabled, metricsReportingEnabled);
        }
        this.api = null == agentApi ? new DDAgentApi(client, agentUrl, featureDiscovery, monitoring, metricsReportingEnabled) : agentApi;
        this.discovery = featureDiscovery;
        this.healthMetrics = healthMetrics;
        this.dispatcher = new PayloadDispatcher(featureDiscovery, this.api, healthMetrics, monitoring);
        this.traceProcessingWorker = new TraceProcessingWorker(traceBufferSize, healthMetrics, monitoring, this.dispatcher, featureDiscovery, null == prioritization ? Prioritization.FAST_LANE : prioritization, flushFrequencySeconds, TimeUnit.SECONDS);
    }

    private DDAgentWriter(DDAgentFeaturesDiscovery discovery, DDAgentApi api, HealthMetrics healthMetrics, Monitoring monitoring, TraceProcessingWorker worker) {
        this.api = api;
        this.discovery = discovery;
        this.healthMetrics = healthMetrics;
        this.traceProcessingWorker = worker;
        this.dispatcher = new PayloadDispatcher(discovery, api, healthMetrics, monitoring);
    }

    private DDAgentWriter(DDAgentFeaturesDiscovery discovery, DDAgentApi api, HealthMetrics healthMetrics, PayloadDispatcher dispatcher, TraceProcessingWorker worker) {
        this.discovery = discovery;
        this.api = api;
        this.healthMetrics = healthMetrics;
        this.traceProcessingWorker = worker;
        this.dispatcher = dispatcher;
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        this.api.addResponseListener(listener);
    }

    public final long getCapacity() {
        return this.traceProcessingWorker.getCapacity();
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (!this.closed) {
            if (trace.isEmpty()) {
                this.handleDroppedTrace("Trace was empty", trace);
            } else {
                int samplingPriority;
                DDSpan root = trace.get(0);
                if (this.traceProcessingWorker.publish(root, samplingPriority = root.context().getSamplingPriority(), trace)) {
                    this.healthMetrics.onPublish(trace, samplingPriority);
                } else {
                    this.handleDroppedTrace("Trace written to overfilled buffer", trace, samplingPriority);
                }
            }
        } else {
            this.handleDroppedTrace("Trace written after shutdown.", trace);
        }
    }

    private void handleDroppedTrace(String reason, List<DDSpan> trace) {
        log.debug("{}. Counted but dropping trace: {}", (Object)reason, trace);
        this.healthMetrics.onFailedPublish(-128);
        this.incrementDropCounts(trace.size());
    }

    private void handleDroppedTrace(String reason, List<DDSpan> trace, int samplingPriority) {
        log.debug("{}. Counted but dropping trace: {}", (Object)reason, trace);
        this.healthMetrics.onFailedPublish(samplingPriority);
        this.incrementDropCounts(trace.size());
    }

    @Override
    public boolean flush() {
        if (!this.closed && this.traceProcessingWorker.flush(1L, TimeUnit.SECONDS)) {
            this.healthMetrics.onFlush(false);
            return true;
        }
        return false;
    }

    public DDAgentApi getApi() {
        return this.api;
    }

    @Override
    public void start() {
        if (!this.closed) {
            this.traceProcessingWorker.start();
            this.healthMetrics.start();
            this.healthMetrics.onStart((int)this.getCapacity());
        }
    }

    @Override
    public void close() {
        boolean flushed = this.flush();
        this.closed = true;
        this.traceProcessingWorker.close();
        this.healthMetrics.close();
        this.healthMetrics.onShutdown(flushed);
    }

    @Override
    public void incrementDropCounts(int spanCount) {
        this.dispatcher.onDroppedTrace(spanCount);
    }

    public static class DDAgentWriterBuilder {
        String agentHost = "localhost";
        int traceAgentPort = 8126;
        String unixDomainSocket = ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET;
        long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        int traceBufferSize = 1024;
        HealthMetrics healthMetrics = new HealthMetrics(StatsDClient.NO_OP);
        int flushFrequencySeconds = 1;
        Monitoring monitoring = Monitoring.DISABLED;
        boolean traceAgentV05Enabled = Config.get().isTraceAgentV05Enabled();
        boolean metricsReportingEnabled = Config.get().isTracerMetricsEnabled();
        private DDAgentApi agentApi;
        private Prioritization prioritization;
        private DDAgentFeaturesDiscovery featureDiscovery;

        public DDAgentWriterBuilder agentApi(DDAgentApi agentApi) {
            this.agentApi = agentApi;
            return this;
        }

        public DDAgentWriterBuilder agentHost(String agentHost) {
            this.agentHost = agentHost;
            return this;
        }

        public DDAgentWriterBuilder traceAgentPort(int traceAgentPort) {
            this.traceAgentPort = traceAgentPort;
            return this;
        }

        public DDAgentWriterBuilder unixDomainSocket(String unixDomainSocket) {
            this.unixDomainSocket = unixDomainSocket;
            return this;
        }

        public DDAgentWriterBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDAgentWriterBuilder traceBufferSize(int traceBufferSize) {
            this.traceBufferSize = traceBufferSize;
            return this;
        }

        public DDAgentWriterBuilder healthMetrics(HealthMetrics healthMetrics) {
            this.healthMetrics = healthMetrics;
            return this;
        }

        public DDAgentWriterBuilder flushFrequencySeconds(int flushFrequencySeconds) {
            this.flushFrequencySeconds = flushFrequencySeconds;
            return this;
        }

        public DDAgentWriterBuilder prioritization(Prioritization prioritization) {
            this.prioritization = prioritization;
            return this;
        }

        public DDAgentWriterBuilder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public DDAgentWriterBuilder traceAgentV05Enabled(boolean traceAgentV05Enabled) {
            this.traceAgentV05Enabled = traceAgentV05Enabled;
            return this;
        }

        public DDAgentWriterBuilder metricsReportingEnabled(boolean metricsReportingEnabled) {
            this.metricsReportingEnabled = metricsReportingEnabled;
            return this;
        }

        public DDAgentWriterBuilder featureDiscovery(DDAgentFeaturesDiscovery featureDiscovery) {
            this.featureDiscovery = featureDiscovery;
            return this;
        }

        public DDAgentWriter build() {
            return new DDAgentWriter(this.agentApi, this.agentHost, this.traceAgentPort, this.unixDomainSocket, this.timeoutMillis, this.traceBufferSize, this.healthMetrics, this.flushFrequencySeconds, this.prioritization, this.monitoring, this.traceAgentV05Enabled, this.metricsReportingEnabled, this.featureDiscovery);
        }
    }
}

