/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.trace.api.Config;
import datadog.trace.api.StatsDClient;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.WriterFactory;
import datadog.trace.core.DDSpan;
import datadog.trace.core.monitor.Monitoring;
import java.util.List;

public class MultiWriter
implements Writer {
    private final Writer[] writers;

    public MultiWriter(Config config, Sampler sampler, StatsDClient statsDClient, Monitoring monitoring, String type) {
        String mwConfig = type.replace("MultiWriter:", "");
        String[] writerConfigs = mwConfig.split(",");
        this.writers = new Writer[writerConfigs.length];
        int i = 0;
        for (String writerConfig : writerConfigs) {
            this.writers[i] = WriterFactory.createWriter(config, sampler, statsDClient, monitoring, writerConfig);
            ++i;
        }
    }

    public MultiWriter(Writer[] writers) {
        this.writers = (Writer[])writers.clone();
    }

    @Override
    public void start() {
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            writer.start();
        }
    }

    @Override
    public void write(List<DDSpan> trace) {
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            writer.write(trace);
        }
    }

    @Override
    public boolean flush() {
        boolean flush = true;
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            flush &= writer.flush();
        }
        return flush;
    }

    @Override
    public void close() {
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            writer.close();
        }
    }

    @Override
    public void incrementDropCounts(int spanCount) {
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            writer.incrementDropCounts(spanCount);
        }
    }
}

