/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.common.container.ServerlessInfo;
import datadog.trace.api.Config;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.StatsDClient;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.LoggingWriter;
import datadog.trace.common.writer.MultiWriter;
import datadog.trace.common.writer.PrintingWriter;
import datadog.trace.common.writer.TraceStructureWriter;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DDAgentFeaturesDiscovery;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.Prioritization;
import datadog.trace.core.http.OkHttpUtils;
import datadog.trace.core.monitor.HealthMetrics;
import datadog.trace.core.monitor.Monitoring;
import datadog.trace.util.Strings;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterFactory {
    private static final Logger log = LoggerFactory.getLogger(WriterFactory.class);

    public static Writer createWriter(Config config, Sampler sampler, StatsDClient statsDClient, Monitoring monitoring) {
        return WriterFactory.createWriter(config, sampler, statsDClient, monitoring, config.getWriterType());
    }

    public static Writer createWriter(Config config, Sampler sampler, StatsDClient statsDClient, Monitoring monitoring, String configuredType) {
        if ("LoggingWriter".equals(configuredType)) {
            return new LoggingWriter();
        }
        if ("PrintingWriter".equals(configuredType)) {
            return new PrintingWriter(System.out, true);
        }
        if (configuredType.startsWith("TraceStructureWriter")) {
            return new TraceStructureWriter(Strings.replace(configuredType, "TraceStructureWriter", ""));
        }
        if (configuredType.startsWith("MultiWriter")) {
            return new MultiWriter(config, sampler, statsDClient, monitoring, configuredType);
        }
        if (!"DDAgentWriter".equals(configuredType)) {
            log.warn("Writer type not configured correctly: Type {} not recognized. Ignoring", (Object)configuredType);
        }
        if (config.isAgentConfiguredUsingDefault() && ServerlessInfo.get().isRunningInServerlessEnvironment()) {
            log.info("Detected serverless environment.  Using PrintingWriter");
            return new PrintingWriter(System.out, true);
        }
        String unixDomainSocket = config.getAgentUnixDomainSocket();
        if (unixDomainSocket != ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET && WriterFactory.isWindows()) {
            log.warn("{} setting not supported on {}.  Reverting to the default.", (Object)"trace.agent.unix.domain.socket", (Object)System.getProperty("os.name"));
            unixDomainSocket = ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET;
        }
        HttpUrl agentUrl = HttpUrl.get((String)config.getAgentUrl());
        OkHttpClient client = OkHttpUtils.buildHttpClient(agentUrl, unixDomainSocket, TimeUnit.SECONDS.toMillis(config.getAgentTimeout()));
        DDAgentFeaturesDiscovery featuresDiscovery = new DDAgentFeaturesDiscovery(client, monitoring, agentUrl, Config.get().isTraceAgentV05Enabled(), Config.get().isTracerMetricsEnabled());
        DDAgentApi ddAgentApi = new DDAgentApi(client, agentUrl, featuresDiscovery, monitoring, Config.get().isTracerMetricsEnabled());
        Prioritization prioritization = config.getEnumValue("prioritization.type", Prioritization.class, Prioritization.FAST_LANE);
        if (Prioritization.ENSURE_TRACE == prioritization) {
            log.info("Using 'EnsureTrace' prioritization type. (Do not use this type if your application is running in production mode)");
        }
        DDAgentWriter ddAgentWriter = DDAgentWriter.builder().agentApi(ddAgentApi).featureDiscovery(featuresDiscovery).prioritization(prioritization).healthMetrics(new HealthMetrics(statsDClient)).monitoring(monitoring).build();
        if (sampler instanceof DDAgentResponseListener) {
            ddAgentWriter.addResponseListener((DDAgentResponseListener)((Object)sampler));
        }
        return ddAgentWriter;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("win");
    }

    private WriterFactory() {
    }
}

