/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import datadog.trace.api.Config;
import datadog.trace.api.Function;
import datadog.trace.api.Functions;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.StatsDClientManager;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.core.monitor.DDAgentStatsDClient;
import datadog.trace.core.monitor.DDAgentStatsDConnection;
import datadog.trace.core.monitor.LoggingStatsDClient;

public final class DDAgentStatsDClientManager
implements StatsDClientManager {
    private static final DDAgentStatsDClientManager INSTANCE = new DDAgentStatsDClientManager();
    private static final boolean USE_LOGGING_CLIENT = "LoggingWriter".equals(Config.get().getWriterType());
    private final DDCache<String, DDAgentStatsDConnection> connectionPool = DDCaches.newUnboundedCache(4);

    public static StatsDClientManager statsDClientManager() {
        return INSTANCE;
    }

    @Override
    public StatsDClient statsDClient(String host, int port, String namespace, String[] constantTags) {
        Functions.Zero<String> nameMapping = Functions.zero();
        Functions.Zero<String[]> tagMapping = Functions.zero();
        if (null != namespace) {
            nameMapping = new NameResolver(namespace);
        }
        if (null != constantTags && constantTags.length > 0) {
            tagMapping = new TagCombiner(constantTags);
        }
        if (USE_LOGGING_CLIENT) {
            return new LoggingStatsDClient(host, port, nameMapping, tagMapping);
        }
        return new DDAgentStatsDClient(this.getConnection(host, port), nameMapping, tagMapping);
    }

    private DDAgentStatsDConnection getConnection(final String host, final int port) {
        String connectionKey = "statsd:" + host + ':' + port;
        return this.connectionPool.computeIfAbsent(connectionKey, new Function<String, DDAgentStatsDConnection>(){

            @Override
            public DDAgentStatsDConnection apply(String unused) {
                return new DDAgentStatsDConnection(host, port);
            }
        });
    }

    static final class TagCombiner
    implements Function<String[], String[]> {
        private final DDCache<String[], String[]> combinedTags = DDCaches.newFixedSizeArrayKeyCache(64);
        private final String[] packedTags;
        private final Function<String[], String[]> tagsInserter;

        public TagCombiner(String[] constantTags) {
            this.packedTags = TagCombiner.pack(constantTags);
            this.tagsInserter = new Function<String[], String[]>(){

                @Override
                public String[] apply(String[] tags) {
                    String[] result = new String[tags.length + 1];
                    System.arraycopy(tags, 0, result, 1, tags.length);
                    result[0] = TagCombiner.this.packedTags[0];
                    return result;
                }
            };
        }

        @Override
        public String[] apply(String[] tags) {
            if (null == tags || tags.length == 0) {
                return this.packedTags;
            }
            return this.combinedTags.computeIfAbsent(tags, this.tagsInserter);
        }

        private static String[] pack(String[] tags) {
            StringBuilder buf = new StringBuilder(tags[0]);
            for (int i = 1; i < tags.length; ++i) {
                buf.append(',').append(tags[i]);
            }
            return new String[]{buf.toString()};
        }
    }

    static final class NameResolver
    implements Function<String, String> {
        private final DDCache<String, String> resolvedNames = DDCaches.newFixedSizeCache(32);
        private final Function<String, String> namePrefixer;

        NameResolver(final String namespace) {
            this.namePrefixer = new Function<String, String>(){
                private final String prefix;
                {
                    this.prefix = namespace + '.';
                }

                @Override
                public String apply(String metricName) {
                    return this.prefix + metricName;
                }
            };
        }

        @Override
        public String apply(String metricName) {
            return this.resolvedNames.computeIfAbsent(metricName, this.namePrefixer);
        }
    }
}

