/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import datadog.trace.api.Config;
import datadog.trace.util.AgentTaskScheduler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DDAgentStatsDConnection
implements StatsDClientErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(DDAgentStatsDConnection.class);
    private static final StatsDClient NO_OP = new NoOpStatsDClient();
    private final String host;
    private final int port;
    private final AtomicInteger clientCount = new AtomicInteger(0);
    private final AtomicInteger errorCount = new AtomicInteger(0);
    volatile StatsDClient statsd = NO_OP;

    DDAgentStatsDConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void handle(Exception e) {
        this.errorCount.incrementAndGet();
        log.error("{} in StatsD client - {}", new Object[]{e.getClass().getSimpleName(), DDAgentStatsDConnection.statsDAddress(this.host, this.port), e});
    }

    public void acquire() {
        if (this.clientCount.getAndIncrement() == 0) {
            this.scheduleConnect();
        }
    }

    public void release() {
        if (this.clientCount.decrementAndGet() == 0) {
            this.doClose();
        }
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    private void scheduleConnect() {
        long remainingDelay = (long)Config.get().getDogStatsDStartDelay() - TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - Config.get().getStartTimeMillis());
        if (remainingDelay > 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Scheduling StatsD connection in {} seconds - {}", (Object)remainingDelay, (Object)DDAgentStatsDConnection.statsDAddress(this.host, this.port));
            }
            AgentTaskScheduler.INSTANCE.scheduleWithJitter(ConnectTask.INSTANCE, this, remainingDelay, TimeUnit.SECONDS);
        } else {
            this.doConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() {
        DDAgentStatsDConnection dDAgentStatsDConnection = this;
        synchronized (dDAgentStatsDConnection) {
            if (NO_OP == this.statsd && this.clientCount.get() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating StatsD client - {}", (Object)DDAgentStatsDConnection.statsDAddress(this.host, this.port));
                }
                String entityID = this.port == 0 ? "none" : null;
                try {
                    this.statsd = new NonBlockingStatsDClient(null, this.host, this.port, Integer.MAX_VALUE, null, (StatsDClientErrorHandler)this, entityID);
                }
                catch (Exception e) {
                    log.error("Unable to create StatsD client - {}", (Object)DDAgentStatsDConnection.statsDAddress(this.host, this.port), (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        DDAgentStatsDConnection dDAgentStatsDConnection = this;
        synchronized (dDAgentStatsDConnection) {
            if (NO_OP != this.statsd && 0 == this.clientCount.get()) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing StatsD client - {}", (Object)DDAgentStatsDConnection.statsDAddress(this.host, this.port));
                }
                try {
                    this.statsd.close();
                }
                catch (Exception e) {
                    log.debug("Problem closing StatsD client - {}", (Object)DDAgentStatsDConnection.statsDAddress(this.host, this.port), (Object)e);
                }
                finally {
                    this.statsd = NO_OP;
                }
            }
        }
    }

    static String statsDAddress(String host, int port) {
        return port > 0 ? host + ':' + port : host;
    }

    private static final class ConnectTask
    implements AgentTaskScheduler.Task<DDAgentStatsDConnection> {
        public static final ConnectTask INSTANCE = new ConnectTask();

        private ConnectTask() {
        }

        @Override
        public void run(DDAgentStatsDConnection target) {
            target.doConnect();
        }
    }
}

