/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci.git;

import datadog.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitConfig;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfoExtractor;
import datadog.trace.bootstrap.instrumentation.ci.git.GitObject;
import datadog.trace.bootstrap.instrumentation.ci.git.GitUtils;
import datadog.trace.bootstrap.instrumentation.ci.git.PersonInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.RawParseUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class LocalFSGitInfoExtractor
implements GitInfoExtractor {
    private static final int TYPE_INDEX = 0;
    private static final int SIZE_INDEX = 1;
    private static final int SHA_INDEX = 1;

    @Override
    public GitInfo headCommit(String gitFolder) {
        try {
            Path gitFolderPath = Paths.get(gitFolder, new String[0]);
            String head = this.readFile(gitFolderPath.resolve("HEAD"));
            String ref = this.extractRef(head);
            String branch = this.extractBranch(ref);
            String tag = this.extractTag(ref);
            String sha = this.extractSha(gitFolderPath, head);
            String repositoryURL = this.extractRepositoryURL(gitFolderPath, branch);
            CommitInfo commitInfo = this.findCommit(gitFolder, sha);
            return new GitInfo(repositoryURL, branch, tag, commitInfo);
        }
        catch (Exception e) {
            return GitInfo.NOOP;
        }
    }

    private String extractRepositoryURL(Path gitFolderPath, String branch) {
        File configFile = gitFolderPath.resolve("config").toFile();
        if (!configFile.exists()) {
            return null;
        }
        GitConfig gitConfig = new GitConfig(configFile.getAbsolutePath());
        String branchRemote = gitConfig.getString("branch \"" + branch + "\"", "remote");
        String remoteUrl = gitConfig.getString("remote \"" + branchRemote + "\"", "url");
        if (remoteUrl == null) {
            remoteUrl = gitConfig.getString("remote \"origin\"", "url");
        }
        return GitUtils.filterSensitiveInfo(remoteUrl);
    }

    private String extractTag(String ref) {
        if (ref != null && ref.contains("refs/tags")) {
            return GitUtils.normalizeRef(ref);
        }
        return null;
    }

    private String extractBranch(String ref) {
        if (ref != null && (ref.contains("origin") || ref.contains("refs/heads"))) {
            return GitUtils.normalizeRef(ref);
        }
        return null;
    }

    private String extractRef(String head) {
        if (head == null || head.isEmpty() || !head.contains("ref:")) {
            return null;
        }
        return head.substring(5);
    }

    private CommitInfo findCommit(String gitFolder, String sha) throws IOException, DataFormatException {
        String filename;
        if (sha == null || sha.isEmpty()) {
            return CommitInfo.NOOP;
        }
        String folder = sha.substring(0, 2);
        File gitObjectFile = Paths.get(gitFolder, "objects", folder, filename = sha.substring(2)).toFile();
        if (!gitObjectFile.exists()) {
            return CommitInfo.NOOP;
        }
        byte[] deflatedBytes = Files.readAllBytes(gitObjectFile.toPath());
        GitObject gitObject = this.inflateGitObject(deflatedBytes);
        return this.parseCommit(gitFolder, sha, gitObject);
    }

    private CommitInfo parseCommit(String gitFolder, String sha, GitObject gitObject) throws IOException, DataFormatException {
        if ("tag".equalsIgnoreCase(gitObject.getType())) {
            int lf = RawParseUtils.nextLF(gitObject.getContent(), 0);
            if (lf == -1) {
                return CommitInfo.NOOP;
            }
            String objectSha = new String(Arrays.copyOfRange(gitObject.getContent(), 0, lf - 1));
            String[] objectShaChunks = objectSha.split(" ");
            if (objectShaChunks.length < 2) {
                return CommitInfo.NOOP;
            }
            String innerSha = objectShaChunks[1];
            return this.findCommit(gitFolder, innerSha);
        }
        if (!"commit".equalsIgnoreCase(gitObject.getType())) {
            return CommitInfo.NOOP;
        }
        byte[] content = gitObject.getContent();
        PersonInfo author = this.getAuthor(content);
        PersonInfo committer = this.getCommitter(content);
        String fullMessage = this.getFullMessage(content);
        return new CommitInfo(sha, author, committer, fullMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GitObject inflateGitObject(byte[] bytes) throws DataFormatException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Inflater ifr = new Inflater();
            ifr.setInput(bytes);
            byte[] tmp = new byte[4096];
            while (!ifr.finished()) {
                int size = ifr.inflate(tmp);
                baos.write(tmp, 0, size);
            }
            byte[] decompressed = baos.toByteArray();
            int separatorIndex = RawParseUtils.findByte(decompressed, (byte)0);
            if (separatorIndex == -1) {
                GitObject gitObject = GitObject.NOOP;
                return gitObject;
            }
            byte[] metadataBytes = Arrays.copyOfRange(decompressed, 0, separatorIndex);
            String[] metadata = new String(metadataBytes).split(" ");
            if (metadata.length != 2) {
                GitObject gitObject = GitObject.NOOP;
                return gitObject;
            }
            byte[] content = Arrays.copyOfRange(decompressed, separatorIndex + 1, decompressed.length);
            GitObject gitObject = new GitObject(metadata[0], Integer.parseInt(metadata[1]), content);
            return gitObject;
        }
        catch (IOException e) {
            return GitObject.NOOP;
        }
    }

    private String extractSha(Path gitFolder, String head) throws IOException {
        if (head == null) {
            return null;
        }
        if (head.contains("ref:")) {
            String refStr = this.extractRef(head);
            if (refStr == null) {
                return null;
            }
            File ref = gitFolder.resolve(refStr).toFile();
            if (!ref.exists()) {
                return null;
            }
            return this.readFile(ref.toPath());
        }
        return head;
    }

    protected PersonInfo getAuthor(byte[] buffer) {
        int authorNameBeginning = RawParseUtils.author(buffer, 0);
        if (authorNameBeginning < 0) {
            return PersonInfo.NOOP;
        }
        return this.parsePersonInfo(buffer, authorNameBeginning);
    }

    protected PersonInfo getCommitter(byte[] buffer) {
        int nameB = RawParseUtils.committer(buffer, 0);
        if (nameB < 0) {
            return PersonInfo.NOOP;
        }
        return this.parsePersonInfo(buffer, nameB);
    }

    protected String getFullMessage(byte[] buffer) {
        int msgB = RawParseUtils.commitMessage(buffer, 0);
        if (msgB < 0) {
            return null;
        }
        return RawParseUtils.decode(buffer, msgB, buffer.length);
    }

    protected PersonInfo parsePersonInfo(byte[] raw, int nameB) {
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailB >= raw.length || raw[emailB] == 10 || emailE >= raw.length - 1 && raw[emailE - 1] != 62) {
            return null;
        }
        int nameEnd = emailB - 2 >= nameB && raw[emailB - 2] == 32 ? emailB - 2 : emailB - 1;
        String name = RawParseUtils.decode(raw, nameB, nameEnd);
        String email = RawParseUtils.decode(raw, emailB, emailE - 1);
        int tzBegin = RawParseUtils.lastIndexOfTrim(raw, ' ', RawParseUtils.nextLF(raw, emailE - 1) - 2) + 1;
        if (tzBegin <= emailE) {
            return new PersonInfo(name, email, 0L, 0);
        }
        int whenBegin = Math.max(emailE, RawParseUtils.lastIndexOfTrim(raw, ' ', tzBegin - 1) + 1);
        if (whenBegin >= tzBegin - 1) {
            return new PersonInfo(name, email, 0L, 0);
        }
        long when = RawParseUtils.parseLongBase10(raw, whenBegin);
        int tz = RawParseUtils.parseTimeZoneOffset(raw, tzBegin);
        return new PersonInfo(name, email, when * 1000L, tz);
    }

    private String readFile(Path filepath) throws IOException {
        if (filepath == null || !filepath.toFile().exists()) {
            return null;
        }
        String content = new String(Files.readAllBytes(filepath));
        if (content.endsWith("\n")) {
            return content.substring(0, content.length() - 1);
        }
        return content;
    }
}

