/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.trace.core.histogram.Histogram;
import datadog.trace.core.histogram.HistogramFactory;
import datadog.trace.core.histogram.Histograms;
import java.util.concurrent.atomic.AtomicLongArray;

public final class AggregateMetric {
    static final long ERROR_TAG = Long.MIN_VALUE;
    static final long TOP_LEVEL_TAG = 0x4000000000000000L;
    private static final HistogramFactory HISTOGRAM_FACTORY = Histograms.newHistogramFactory();
    private final Histogram okLatencies = HISTOGRAM_FACTORY.newHistogram();
    private final Histogram errorLatencies = HISTOGRAM_FACTORY.newHistogram();
    private int errorCount;
    private int hitCount;
    private int topLevelCount;
    private long duration;

    public AggregateMetric recordDurations(int count, AtomicLongArray durations) {
        this.hitCount += count;
        for (int i = 0; i < count && i < durations.length(); ++i) {
            long duration = durations.getAndSet(i, 0L);
            if ((duration & 0x4000000000000000L) == 0x4000000000000000L) {
                duration ^= 0x4000000000000000L;
                ++this.topLevelCount;
            }
            if ((duration & Long.MIN_VALUE) == Long.MIN_VALUE) {
                this.errorLatencies.accept(duration ^= Long.MIN_VALUE);
                ++this.errorCount;
            } else {
                this.okLatencies.accept(duration);
            }
            this.duration += duration;
        }
        return this;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getTopLevelCount() {
        return this.topLevelCount;
    }

    public long getDuration() {
        return this.duration;
    }

    public Histogram getOkLatencies() {
        return this.okLatencies;
    }

    public Histogram getErrorLatencies() {
        return this.errorLatencies;
    }

    public void clear() {
        this.errorCount = 0;
        this.hitCount = 0;
        this.topLevelCount = 0;
        this.duration = 0L;
        this.okLatencies.clear();
        this.errorLatencies.clear();
    }
}

