/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.trace.api.DDId;
import datadog.trace.common.writer.Writer;
import datadog.trace.core.DDSpan;
import datadog.trace.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceStructureWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(TraceStructureWriter.class);
    private final PrintStream out;
    private final boolean debugLog;

    public TraceStructureWriter() {
        this("", false);
    }

    public TraceStructureWriter(boolean debugLog) {
        this("", debugLog);
    }

    public TraceStructureWriter(String outputFile) {
        this(outputFile, false);
    }

    public TraceStructureWriter(String outputFile, boolean debugLog) {
        this.debugLog = debugLog;
        try {
            this.out = outputFile.isEmpty() || outputFile.equals(":") ? System.err : new PrintStream(new FileOutputStream(new File(Strings.replace(outputFile, ":", ""))));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create trace structure writer from " + outputFile, e);
        }
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (trace.isEmpty()) {
            this.output("[]", null, null);
        } else {
            DDId traceId = trace.get(0).getTraceId();
            DDId rootSpanId = trace.get(0).getSpanId();
            HashMap<DDId, Node> nodesById = new HashMap<DDId, Node>();
            for (DDSpan span : trace) {
                if (DDId.ZERO.equals((Object)span.getParentId())) {
                    rootSpanId = span.getSpanId();
                }
                nodesById.put(span.getSpanId(), new Node(span));
            }
            for (DDSpan span : trace) {
                if (!traceId.equals((Object)span.getTraceId())) {
                    String message = "Trace " + traceId + " has broken trace link at " + span.getSpanId() + "(" + span.getOperationName() + ")->" + span.getTraceId();
                    this.out.println("ERROR: " + message);
                    if (this.debugLog) {
                        log.error(message);
                    }
                    return;
                }
                if (rootSpanId.equals((Object)span.getSpanId())) continue;
                Node parent = (Node)nodesById.get(span.getParentId());
                if (null == parent) {
                    String message = "Trace " + traceId + " has broken link at " + span.getSpanId() + "(" + span.getOperationName() + ")->" + span.getParentId();
                    this.out.println("ERROR: " + message);
                    if (this.debugLog) {
                        log.error(message);
                    }
                    return;
                }
                parent.addChild((Node)nodesById.get(span.getSpanId()));
            }
            this.output(String.valueOf(nodesById.get(rootSpanId)), traceId, rootSpanId);
        }
    }

    private void output(String trace, DDId traceId, DDId rootSpanId) {
        this.out.println(trace);
        if (this.debugLog && log.isDebugEnabled()) {
            StringBuilder start = new StringBuilder();
            if (traceId != null) {
                start.append("t_id=").append(traceId);
            }
            if (rootSpanId != null) {
                if (start.length() > 0) {
                    start.append(", ");
                }
                start.append("s_id=").append(rootSpanId);
            }
            if (start.length() > 0) {
                start.append(" -> ");
            }
            log.debug("{}wrote {}", (Object)start, (Object)trace);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean flush() {
        this.out.flush();
        return true;
    }

    @Override
    public void close() {
        if (this.out != System.err) {
            this.out.close();
        }
    }

    @Override
    public void incrementDropCounts(int spanCount) {
    }

    private static final class Node {
        private final CharSequence operationName;
        private final List<Node> children = new ArrayList<Node>();

        private Node(DDSpan span) {
            this.operationName = span.getOperationName();
        }

        public void addChild(Node child) {
            this.children.add(child);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.operationName);
            for (Node node : this.children) {
                sb.append(node);
            }
            return sb.append("]").toString();
        }
    }
}

