/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.ContextInterpreter;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.propagation.TagContextExtractor;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class B3HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(B3HttpCodec.class);
    private static final String B3_TRACE_ID = "b3.traceid";
    private static final String B3_SPAN_ID = "b3.spanid";
    private static final String TRACE_ID_KEY = "X-B3-TraceId";
    private static final String SPAN_ID_KEY = "X-B3-SpanId";
    private static final String SAMPLING_PRIORITY_KEY = "X-B3-Sampled";
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);

    private B3HttpCodec() {
    }

    public static HttpCodec.Extractor newExtractor(Map<String, String> tagMapping) {
        return new TagContextExtractor(tagMapping, new ContextInterpreter.Factory(){

            @Override
            protected ContextInterpreter construct(Map<String, String> mapping) {
                return new B3ContextInterpreter(mapping);
            }
        });
    }

    private static class B3ContextInterpreter
    extends ContextInterpreter {
        private static final int TRACE_ID = 0;
        private static final int SPAN_ID = 1;
        private static final int TAGS = 2;
        private static final int SAMPLING_PRIORITY = 3;
        private static final int IGNORE = -1;

        private B3ContextInterpreter(Map<String, String> taggedHeaders) {
            super(taggedHeaders);
        }

        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty()) {
                return true;
            }
            String lowerCaseKey = null;
            int classification = -1;
            if (Character.toLowerCase(key.charAt(0)) == 'x') {
                if (B3HttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                    classification = 0;
                } else if (B3HttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                    classification = 1;
                } else if (B3HttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                    classification = 3;
                } else if (this.handledForwarding(key, value)) {
                    return true;
                }
            }
            if (!this.taggedHeaders.isEmpty() && classification == -1 && this.taggedHeaders.containsKey(lowerCaseKey = this.toLowerCase(key))) {
                classification = 2;
            }
            if (classification != -1) {
                try {
                    String firstValue = HttpCodec.firstHeaderValue(value);
                    if (null != firstValue) {
                        switch (classification) {
                            case 0: {
                                int length = firstValue.length();
                                if (length > 32) {
                                    log.debug("Header {} exceeded max length of 32: {}", (Object)B3HttpCodec.TRACE_ID_KEY, (Object)value);
                                    this.traceId = DDId.ZERO;
                                    return true;
                                }
                                this.traceId = DDId.fromHexTruncatedWithOriginal((String)value);
                                if (this.tags.isEmpty()) {
                                    this.tags = new TreeMap();
                                }
                                this.tags.put(B3HttpCodec.B3_TRACE_ID, firstValue);
                                break;
                            }
                            case 1: {
                                this.spanId = DDId.fromHexWithOriginal((String)firstValue);
                                if (this.tags.isEmpty()) {
                                    this.tags = new TreeMap();
                                }
                                this.tags.put(B3HttpCodec.B3_SPAN_ID, firstValue);
                                break;
                            }
                            case 3: {
                                this.samplingPriority = this.convertSamplingPriority(firstValue);
                                break;
                            }
                            case 2: {
                                String mappedKey = (String)this.taggedHeaders.get(lowerCaseKey);
                                if (null == mappedKey) break;
                                if (this.tags.isEmpty()) {
                                    this.tags = new TreeMap();
                                }
                                this.tags.put(mappedKey, HttpCodec.decode(firstValue));
                                break;
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.invalidateContext();
                    log.debug("Exception when extracting context", (Throwable)e);
                    return false;
                }
            }
            return true;
        }

        private int convertSamplingPriority(String samplingPriority) {
            return "1".equals(samplingPriority) ? 1 : 0;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            block3: {
                try {
                    String injectedTraceId = context.getTraceId().toHexStringOrOriginal();
                    setter.set(carrier, B3HttpCodec.TRACE_ID_KEY, injectedTraceId);
                    setter.set(carrier, B3HttpCodec.SPAN_ID_KEY, context.getSpanId().toHexStringOrOriginal());
                    if (context.lockSamplingPriority()) {
                        setter.set(carrier, B3HttpCodec.SAMPLING_PRIORITY_KEY, this.convertSamplingPriority(context.getSamplingPriority()));
                    }
                    log.debug("{} - B3 parent context injected - {}", (Object)context.getTraceId(), (Object)injectedTraceId);
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Cannot parse context id(s): {} {}", new Object[]{context.getTraceId(), context.getSpanId(), e});
                }
            }
        }

        private String convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
        }
    }
}

