/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import datadog.trace.api.Platform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.Set;

public final class CollectionUtils {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle IMMUTABLE_COPY_OF_SET = CollectionUtils.findCopyOf(Set.class);

    public static <T> Set<T> immutableSet(Set<T> set) {
        if (null != IMMUTABLE_COPY_OF_SET) {
            try {
                return IMMUTABLE_COPY_OF_SET.invokeExact(set);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSet(set);
    }

    private static MethodHandle findCopyOf(Class<?> clazz) {
        if (Platform.isJavaVersionAtLeast(10)) {
            try {
                return LOOKUP.findStatic(clazz, "copyOf", MethodType.methodType(clazz, clazz));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }
}

