/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.bootstrap.instrumentation.api.InstrumentationTags;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.Metadata;
import datadog.trace.core.MetadataConsumer;
import datadog.trace.core.http.OkHttpUtils;
import datadog.trace.core.serialization.Writable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import okhttp3.RequestBody;

public final class TraceMapperV0_4
implements TraceMapper {
    public static final byte[] SERVICE = "service".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] NAME = "name".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] RESOURCE = "resource".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] TRACE_ID = "trace_id".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] SPAN_ID = "span_id".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] PARENT_ID = "parent_id".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] START = "start".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] DURATION = "duration".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] TYPE = "type".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] ERROR = "error".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] METRICS = "metrics".getBytes(StandardCharsets.ISO_8859_1);
    public static final byte[] META = "meta".getBytes(StandardCharsets.ISO_8859_1);
    private final int size;
    private final MetaWriter metaWriter = new MetaWriter();

    public TraceMapperV0_4(int size) {
        this.size = size;
    }

    public TraceMapperV0_4() {
        this(0x500000);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        writable.startArray(trace.size());
        for (CoreSpan<?> span : trace) {
            writable.startMap(12);
            writable.writeUTF8(SERVICE);
            writable.writeString(span.getServiceName(), null);
            writable.writeUTF8(NAME);
            writable.writeObject(span.getOperationName(), null);
            writable.writeUTF8(RESOURCE);
            writable.writeObject(span.getResourceName(), null);
            writable.writeUTF8(TRACE_ID);
            writable.writeLong(span.getTraceId().toLong());
            writable.writeUTF8(SPAN_ID);
            writable.writeLong(span.getSpanId().toLong());
            writable.writeUTF8(PARENT_ID);
            writable.writeLong(span.getParentId().toLong());
            writable.writeUTF8(START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeLong(span.getDurationNano());
            writable.writeUTF8(TYPE);
            writable.writeString(span.getType(), null);
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable));
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_4();
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
    }

    @Override
    public String endpoint() {
        return "v0.4";
    }

    private static class PayloadV0_4
    extends Payload {
        private PayloadV0_4() {
        }

        @Override
        int sizeInBytes() {
            return this.msgpackArrayHeaderSize(this.traceCount()) + this.body.remaining();
        }

        @Override
        void writeTo(WritableByteChannel channel) throws IOException {
            ByteBuffer header = this.msgpackArrayHeader(this.traceCount());
            while (header.hasRemaining()) {
                channel.write(header);
            }
            while (this.body.hasRemaining()) {
                channel.write(this.body);
            }
        }

        @Override
        RequestBody toRequest() {
            return OkHttpUtils.msgpackRequestBodyOf(Arrays.asList(this.msgpackArrayHeader(this.traceCount()), this.body));
        }
    }

    private static final class MetaWriter
    extends MetadataConsumer {
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int metaSize = metadata.getBaggage().size() + metadata.getTags().size() + (null == metadata.getHttpStatusCode() ? 0 : 1) + 1;
            int metricsSize = (metadata.hasSamplingPriority() ? 1 : 0) + (metadata.measured() ? 1 : 0) + (metadata.topLevel() ? 1 : 0) + 1;
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                ++metricsSize;
                --metaSize;
            }
            this.writable.writeUTF8(METRICS);
            this.writable.startMap(metricsSize);
            if (metadata.hasSamplingPriority()) {
                this.writable.writeUTF8(TraceMapper.SAMPLING_PRIORITY_KEY);
                this.writable.writeInt(metadata.samplingPriority());
            }
            if (metadata.measured()) {
                this.writable.writeUTF8(InstrumentationTags.DD_MEASURED);
                this.writable.writeInt(1);
            }
            if (metadata.topLevel()) {
                this.writable.writeUTF8(InstrumentationTags.DD_TOP_LEVEL);
                this.writable.writeInt(1);
            }
            this.writable.writeUTF8(TraceMapper.THREAD_ID);
            this.writable.writeLong(metadata.getThreadId());
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObject(entry.getValue(), null);
            }
            this.writable.writeUTF8(META);
            this.writable.startMap(metaSize);
            for (Map.Entry<String, Object> entry : metadata.getBaggage().entrySet()) {
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeString((CharSequence)entry.getValue(), null);
            }
            this.writable.writeUTF8(TraceMapper.THREAD_NAME);
            this.writable.writeUTF8(metadata.getThreadName());
            if (null != metadata.getHttpStatusCode()) {
                this.writable.writeUTF8(TraceMapper.HTTP_STATUS);
                this.writable.writeUTF8(metadata.getHttpStatusCode());
            }
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (entry.getValue() instanceof Number) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObject(entry.getValue(), null);
            }
        }
    }
}

