/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.CustomScopeManagerWrapper;
import datadog.opentracing.DefaultLogHandler;
import datadog.opentracing.LogHandler;
import datadog.opentracing.OTScopeManager;
import datadog.opentracing.TypeConverter;
import datadog.trace.api.Config;
import datadog.trace.api.GlobalTracer;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.Writer;
import datadog.trace.context.ScopeListener;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HttpCodec;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import io.opentracing.tag.Tag;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDTracer
implements Tracer,
datadog.trace.api.Tracer {
    private static final Logger log = LoggerFactory.getLogger(DDTracer.class);
    private final TypeConverter converter;
    private final AgentTracer.TracerAPI tracer;
    private ScopeManager scopeManager;

    public static DDTracerBuilder builder() {
        return new DDTracerBuilder();
    }

    @Deprecated
    public DDTracer() {
        this(CoreTracer.builder().build());
    }

    @Deprecated
    public DDTracer(String serviceName) {
        this(CoreTracer.builder().serviceName(serviceName).build());
    }

    @Deprecated
    public DDTracer(Properties properties) {
        this(CoreTracer.builder().withProperties(properties).build());
    }

    @Deprecated
    public DDTracer(Config config) {
        this(CoreTracer.builder().config(config).build());
    }

    @Deprecated
    public DDTracer(String serviceName, Writer writer, Sampler sampler) {
        this(CoreTracer.builder().serviceName(serviceName).writer(writer).sampler(sampler).build());
    }

    @Deprecated
    DDTracer(String serviceName, Writer writer, Sampler sampler, Map<String, String> runtimeTags) {
        this(CoreTracer.builder().serviceName(serviceName).writer(writer).sampler(sampler).localRootSpanTags(runtimeTags).build());
    }

    @Deprecated
    public DDTracer(Writer writer) {
        this(CoreTracer.builder().writer(writer).build());
    }

    @Deprecated
    public DDTracer(Config config, Writer writer) {
        this(CoreTracer.builder().config(config).writer(writer).build());
    }

    @Deprecated
    public DDTracer(String serviceName, Writer writer, Sampler sampler, String runtimeId, Map<String, String> localRootSpanTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders) {
        this(CoreTracer.builder().serviceName(serviceName).writer(writer).sampler(sampler).localRootSpanTags(DDTracer.customRuntimeTags(runtimeId, localRootSpanTags)).defaultSpanTags(defaultSpanTags).serviceNameMappings(serviceNameMappings).taggedHeaders(taggedHeaders).build());
    }

    @Deprecated
    public DDTracer(String serviceName, Writer writer, Sampler sampler, Map<String, String> localRootSpanTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders) {
        this(CoreTracer.builder().serviceName(serviceName).writer(writer).sampler(sampler).localRootSpanTags(localRootSpanTags).defaultSpanTags(defaultSpanTags).serviceNameMappings(serviceNameMappings).taggedHeaders(taggedHeaders).build());
    }

    @Deprecated
    public DDTracer(String serviceName, Writer writer, Sampler sampler, Map<String, String> localRootSpanTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, int partialFlushMinSpans) {
        this(CoreTracer.builder().serviceName(serviceName).writer(writer).sampler(sampler).localRootSpanTags(localRootSpanTags).defaultSpanTags(defaultSpanTags).serviceNameMappings(serviceNameMappings).taggedHeaders(taggedHeaders).partialFlushMinSpans(partialFlushMinSpans).build());
    }

    @Deprecated
    public DDTracer(AgentTracer.TracerAPI tracer) {
        this.tracer = tracer;
        this.converter = new TypeConverter(new DefaultLogHandler());
        this.scopeManager = new OTScopeManager(tracer, this.converter);
    }

    private DDTracer(@Deprecated Config config, String serviceName, Writer writer, Sampler sampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, ScopeManager scopeManager, Map<String, String> localRootSpanTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, int partialFlushMinSpans, LogHandler logHandler, StatsDClient statsDClient) {
        if ((writer == null || writer.getClass().getName().equals("datadog.trace.common.writer.DDAgentWriter")) && GlobalTracer.get().getClass().getName().equals("datadog.trace.agent.core.CoreTracer")) {
            log.error("Datadog Tracer already installed by `dd-java-agent`. NOTE: Manually creating the tracer while using `dd-java-agent` is not supported");
            throw new IllegalStateException("Datadog Tracer already installed");
        }
        this.converter = logHandler != null ? new TypeConverter(logHandler) : new TypeConverter(new DefaultLogHandler());
        CoreTracer.CoreTracerBuilder builder = CoreTracer.builder();
        if (config != null) {
            builder = builder.config(config);
        }
        if (serviceName != null) {
            builder = builder.serviceName(serviceName);
        }
        if (writer != null) {
            builder = builder.writer(writer);
        }
        if (sampler != null) {
            builder = builder.sampler(sampler);
        }
        if (injector != null) {
            builder = builder.injector(injector);
        }
        if (extractor != null) {
            builder = builder.extractor(extractor);
        }
        if (scopeManager != null) {
            this.scopeManager = scopeManager;
            builder = builder.scopeManager(new CustomScopeManagerWrapper(scopeManager, this.converter));
        }
        if (localRootSpanTags != null) {
            builder = builder.localRootSpanTags(localRootSpanTags);
        }
        if (defaultSpanTags != null) {
            builder = builder.defaultSpanTags(defaultSpanTags);
        }
        if (serviceNameMappings != null) {
            builder = builder.serviceNameMappings(serviceNameMappings);
        }
        if (taggedHeaders != null) {
            builder = builder.taggedHeaders(taggedHeaders);
        }
        if (partialFlushMinSpans != 0) {
            builder = builder.partialFlushMinSpans(partialFlushMinSpans);
        }
        if (statsDClient != null) {
            builder = builder.statsDClient(statsDClient);
        }
        this.tracer = builder.build();
        if (scopeManager == null) {
            this.scopeManager = new OTScopeManager(this.tracer, this.converter);
        }
    }

    private static Map<String, String> customRuntimeTags(String runtimeId, Map<String, String> applicationRootSpanTags) {
        HashMap<String, String> runtimeTags = new HashMap<String, String>(applicationRootSpanTags);
        runtimeTags.put("runtime-id", runtimeId);
        return Collections.unmodifiableMap(runtimeTags);
    }

    public String getTraceId() {
        return this.tracer.getTraceId();
    }

    public String getSpanId() {
        return this.tracer.getSpanId();
    }

    public boolean addTraceInterceptor(TraceInterceptor traceInterceptor) {
        return this.tracer.addTraceInterceptor(traceInterceptor);
    }

    public void addScopeListener(ScopeListener listener) {
        this.tracer.addScopeListener(listener);
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        return this.scopeManager.activeSpan();
    }

    public Scope activateSpan(Span span) {
        return this.scopeManager.activate(span);
    }

    public DDSpanBuilder buildSpan(String operationName) {
        return new DDSpanBuilder(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (carrier instanceof TextMapInject) {
            AgentSpan.Context context = this.converter.toContext(spanContext);
            this.tracer.inject(context, (TextMapInject)carrier, TextMapInjectSetter.INSTANCE);
        } else {
            log.debug("Unsupported format for propagation - {}", (Object)format.getClass().getName());
        }
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        if (carrier instanceof TextMapExtract) {
            AgentSpan.Context.Extracted tagContext = this.tracer.extract((TextMapExtract)carrier, new TextMapExtractGetter((TextMapExtract)carrier));
            return this.converter.toSpanContext(tagContext);
        }
        log.debug("Unsupported format for propagation - {}", (Object)format.getClass().getName());
        return null;
    }

    public void close() {
        this.tracer.close();
    }

    static {
        ClassLoader classLoader = DDTracer.class.getClassLoader();
        if (classLoader == null) {
            log.error("dd-trace-ot should not be on the bootstrap classpath.");
        } else {
            try {
                Class<?> bootstrapClass = Class.forName("datadog.trace.bootstrap.AgentBootstrap", false, classLoader);
                if (bootstrapClass.getClassLoader() == null) {
                    log.error("dd-trace-ot should not be used with dd-java-agent.");
                } else {
                    log.error("dd-java-agent should not be on the classpath.");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public class DDSpanBuilder
    implements Tracer.SpanBuilder {
        private final AgentTracer.SpanBuilder delegate;

        public DDSpanBuilder(String operationName) {
            this.delegate = DDTracer.this.tracer.buildSpan(operationName);
        }

        public DDSpanBuilder asChildOf(SpanContext parent) {
            this.delegate.asChildOf(DDTracer.this.converter.toContext(parent));
            return this;
        }

        public DDSpanBuilder asChildOf(Span parent) {
            if (parent != null) {
                this.delegate.asChildOf(DDTracer.this.converter.toAgentSpan(parent).context());
            }
            return this;
        }

        public DDSpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            if (referencedContext == null) {
                return this;
            }
            AgentSpan.Context context = DDTracer.this.converter.toContext(referencedContext);
            if (!(context instanceof ExtractedContext) && !(context instanceof DDSpanContext)) {
                log.debug("Expected to have a DDSpanContext or ExtractedContext but got " + context.getClass().getName());
                return this;
            }
            if ("child_of".equals(referenceType) || "follows_from".equals(referenceType)) {
                this.delegate.asChildOf(context);
            } else {
                log.debug("Only support reference type of CHILD_OF and FOLLOWS_FROM");
            }
            return this;
        }

        public DDSpanBuilder ignoreActiveSpan() {
            this.delegate.ignoreActiveSpan();
            return this;
        }

        public DDSpanBuilder withTag(String key, String value) {
            this.delegate.withTag(key, value);
            return this;
        }

        public DDSpanBuilder withTag(String key, boolean value) {
            this.delegate.withTag(key, value);
            return this;
        }

        public DDSpanBuilder withTag(String key, Number value) {
            this.delegate.withTag(key, value);
            return this;
        }

        public <T> DDSpanBuilder withTag(Tag<T> tag, T value) {
            this.delegate.withTag(tag.getKey(), value);
            return this;
        }

        public DDSpanBuilder withStartTimestamp(long microseconds) {
            this.delegate.withStartTimestamp(microseconds);
            return this;
        }

        public Span startManual() {
            return this.start();
        }

        public Span start() {
            AgentSpan agentSpan = this.delegate.start();
            return DDTracer.this.converter.toSpan(agentSpan);
        }

        @Deprecated
        public Scope startActive(boolean finishSpanOnClose) {
            return DDTracer.this.scopeManager.activate(this.start(), finishSpanOnClose);
        }

        public DDSpanBuilder withServiceName(String serviceName) {
            this.delegate.withServiceName(serviceName);
            return this;
        }

        public DDSpanBuilder withResourceName(String resourceName) {
            this.delegate.withResourceName(resourceName);
            return this;
        }

        public DDSpanBuilder withErrorFlag() {
            this.delegate.withErrorFlag();
            return this;
        }

        public DDSpanBuilder withSpanType(String spanType) {
            this.delegate.withSpanType(spanType);
            return this;
        }
    }

    private static class TextMapExtractGetter
    implements AgentPropagation.ContextVisitor<TextMapExtract> {
        private final TextMapExtract carrier;

        private TextMapExtractGetter(TextMapExtract carrier) {
            this.carrier = carrier;
        }

        @Override
        public void forEachKey(TextMapExtract ignored, AgentPropagation.KeyClassifier classifier) {
            for (Map.Entry entry : this.carrier) {
                if (classifier.accept((String)entry.getKey(), (String)entry.getValue())) continue;
                return;
            }
        }
    }

    private static class TextMapInjectSetter
    implements AgentPropagation.Setter<TextMapInject> {
        static final TextMapInjectSetter INSTANCE = new TextMapInjectSetter();

        private TextMapInjectSetter() {
        }

        @Override
        public void set(TextMapInject carrier, String key, String value) {
            carrier.put(key, value);
        }
    }

    public static class DDTracerBuilder {
        private Config config;
        private String serviceName;
        private Writer writer;
        private Sampler sampler;
        private HttpCodec.Injector injector;
        private HttpCodec.Extractor extractor;
        private ScopeManager scopeManager;
        private Map<String, String> localRootSpanTags;
        private Map<String, String> defaultSpanTags;
        private Map<String, String> serviceNameMappings;
        private Map<String, String> taggedHeaders;
        private int partialFlushMinSpans;
        private LogHandler logHandler;
        private StatsDClient statsDClient;

        public DDTracerBuilder config(Config config) {
            this.config = config;
            return this;
        }

        public DDTracerBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public DDTracerBuilder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public DDTracerBuilder sampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public DDTracerBuilder injector(HttpCodec.Injector injector) {
            this.injector = injector;
            return this;
        }

        public DDTracerBuilder extractor(HttpCodec.Extractor extractor) {
            this.extractor = extractor;
            return this;
        }

        public DDTracerBuilder scopeManager(ScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public DDTracerBuilder localRootSpanTags(Map<String, String> localRootSpanTags) {
            this.localRootSpanTags = localRootSpanTags;
            return this;
        }

        public DDTracerBuilder defaultSpanTags(Map<String, String> defaultSpanTags) {
            this.defaultSpanTags = defaultSpanTags;
            return this;
        }

        public DDTracerBuilder serviceNameMappings(Map<String, String> serviceNameMappings) {
            this.serviceNameMappings = serviceNameMappings;
            return this;
        }

        public DDTracerBuilder taggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = taggedHeaders;
            return this;
        }

        public DDTracerBuilder partialFlushMinSpans(int partialFlushMinSpans) {
            this.partialFlushMinSpans = partialFlushMinSpans;
            return this;
        }

        public DDTracerBuilder logHandler(LogHandler logHandler) {
            this.logHandler = logHandler;
            return this;
        }

        public DDTracerBuilder statsDClient(StatsDClient statsDClient) {
            this.statsDClient = statsDClient;
            return this;
        }

        public DDTracerBuilder withProperties(Properties properties) {
            return this.config(Config.get(properties));
        }

        public DDTracer build() {
            return new DDTracer(this.config, this.serviceName, this.writer, this.sampler, this.injector, this.extractor, this.scopeManager, this.localRootSpanTags, this.defaultSpanTags, this.serviceNameMappings, this.taggedHeaders, this.partialFlushMinSpans, this.logHandler, this.statsDClient);
        }
    }
}

